package main

import (
	"context"

	"github.com/projectdiscovery/gologger"
	"github.com/projectdiscovery/subfinder/pkg/runner"
)

func main() {
	// Parse the command line flags and read config files
	options := runner.ParseOptions()

	newRunner, err := runner.NewRunner(options)
	if err != nil {
		gologger.Fatalf("Could not create runner: %s\n", err)
	}

	err = newRunner.RunEnumeration(context.Background())
	if err != nil {
		gologger.Fatalf("Could not run enumeration: %s\n", err)
	}
}
