export function TurborepoIconLight() {
  return (
    <svg
      width="84"
      height="84"
      viewBox="0 0 84 84"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect width="84" height="84" rx="42" fill="white" />
      <path
        d="M41.8883 27.9263C34.1897 27.9263 27.9263 34.1897 27.9263 41.8883C27.9263 49.5869 34.1897 55.8503 41.8883 55.8503C49.5869 55.8503 55.8503 49.5869 55.8503 41.8883C55.8503 34.1897 49.5869 27.9263 41.8883 27.9263ZM41.8883 49.1137C37.8973 49.1137 34.6629 45.8793 34.6629 41.8883C34.6629 37.8973 37.8973 34.6629 41.8883 34.6629C45.8793 34.6629 49.1137 37.8973 49.1137 41.8883C49.1137 45.8793 45.8793 49.1137 41.8883 49.1137Z"
        fill="black"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M43.0581 25.6329V20.4199C54.3889 21.0257 63.3901 30.4065 63.3901 41.8881C63.3901 53.3697 54.3889 62.7479 43.0581 63.3563V58.1433C51.5029 57.5401 58.1901 50.4837 58.1901 41.8881C58.1901 33.2925 51.5029 26.2361 43.0581 25.6329ZM29.5745 52.5481C27.3359 49.9637 25.8929 46.6721 25.6355 43.0581H20.4199C20.6903 48.1151 22.7131 52.7041 25.8825 56.2375L29.5719 52.5481H29.5745ZM40.7182 63.3563V58.1433C37.1016 57.8859 33.81 56.4455 31.2256 54.2043L27.5362 57.8937C31.0722 61.0657 35.6612 63.0859 40.7156 63.3563H40.7182Z"
        fill="url(#paint0_linear_967_9048)"
      />
      <rect
        x="0.5"
        y="0.5"
        width="83"
        height="83"
        rx="41.5"
        stroke="url(#paint1_radial_967_9048)"
        strokeOpacity="0.15"
      />
      <rect
        x="0.5"
        y="0.5"
        width="83"
        height="83"
        rx="41.5"
        stroke="url(#paint2_linear_967_9048)"
        strokeOpacity="0.5"
      />
      <defs>
        <linearGradient
          id="paint0_linear_967_9048"
          x1="43.9007"
          y1="23.4388"
          x2="22.7679"
          y2="44.5716"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
        <radialGradient
          id="paint1_radial_967_9048"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(42) rotate(90) scale(108)"
        >
          <stop />
          <stop offset="1" />
        </radialGradient>
        <linearGradient
          id="paint2_linear_967_9048"
          x1="0"
          y1="0"
          x2="18.375"
          y2="34.125"
          gradientUnits="userSpaceOnUse"
        >
          <stop />
          <stop offset="1" stopOpacity="0" />
        </linearGradient>
      </defs>
    </svg>
  );
}

export function TurborepoIconDark() {
  return (
    <svg
      width="84"
      height="84"
      viewBox="0 0 84 84"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect width="84" height="84" rx="42" fill="black" />
      <path
        d="M41.8878 27.9263C34.1892 27.9263 27.9258 34.1897 27.9258 41.8883C27.9258 49.5869 34.1892 55.8503 41.8878 55.8503C49.5864 55.8503 55.8498 49.5869 55.8498 41.8883C55.8498 34.1897 49.5864 27.9263 41.8878 27.9263ZM41.8878 49.1137C37.8968 49.1137 34.6624 45.8793 34.6624 41.8883C34.6624 37.8973 37.8968 34.6629 41.8878 34.6629C45.8788 34.6629 49.1132 37.8973 49.1132 41.8883C49.1132 45.8793 45.8788 49.1137 41.8878 49.1137Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M43.0581 25.6329V20.4199C54.3889 21.0257 63.3901 30.4065 63.3901 41.8881C63.3901 53.3697 54.3889 62.7479 43.0581 63.3563V58.1433C51.5029 57.5401 58.1901 50.4837 58.1901 41.8881C58.1901 33.2925 51.5029 26.2361 43.0581 25.6329ZM29.5745 52.5481C27.3359 49.9637 25.8929 46.6721 25.6355 43.0581H20.4199C20.6903 48.1151 22.7131 52.7041 25.8825 56.2375L29.5719 52.5481H29.5745ZM40.7182 63.3563V58.1433C37.1016 57.8859 33.81 56.4455 31.2256 54.2043L27.5362 57.8937C31.0722 61.0657 35.6612 63.0859 40.7156 63.3563H40.7182Z"
        fill="url(#paint0_linear_967_8719)"
      />
      <rect
        x="0.5"
        y="0.5"
        width="83"
        height="83"
        rx="41.5"
        stroke="url(#paint1_radial_967_8719)"
        strokeOpacity="0.15"
      />
      <rect
        x="0.5"
        y="0.5"
        width="83"
        height="83"
        rx="41.5"
        stroke="url(#paint2_linear_967_8719)"
        strokeOpacity="0.5"
      />
      <defs>
        <linearGradient
          id="paint0_linear_967_8719"
          x1="43.9007"
          y1="23.4388"
          x2="22.7679"
          y2="44.5716"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
        <radialGradient
          id="paint1_radial_967_8719"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(42) rotate(90) scale(108)"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" />
        </radialGradient>
        <linearGradient
          id="paint2_linear_967_8719"
          x1="0"
          y1="0"
          x2="18.375"
          y2="34.125"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
      </defs>
    </svg>
  );
}

export function TurborepoIconOutline() {
  return (
    <svg
      width="124"
      height="124"
      viewBox="0 0 124 124"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect
        x="0.5"
        y="0.5"
        width="123"
        height="123"
        rx="61.5"
        stroke="white"
        strokeOpacity="0.05"
      />
    </svg>
  );
}

export function Turborepo() {
  return (
    <div className="relative w-24 h-24">
      <div className="pointer-events-none absolute w-[261px] h-[261px] top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-gradient-to-b from-[#FF3358] to-[#FF4FD8] mix-blend-normal opacity-5 dark:opacity-[0.15] blur-[60px]" />
      <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
        <div className="contents dark:hidden">
          <TurborepoIconLight />
        </div>
        <div className="dark:contents hidden">
          <TurborepoIconDark />
        </div>
      </div>
    </div>
  );
}
