export const temporaryChangesTable = `const result = await db
  .mergeInto("wine as target")
  .using(
    "wine_stock_change as source",
    "source.wine_name",
    "target.name",
  )
  .whenNotMatchedAnd("source.stock_delta", ">", 0)
  .thenInsertValues(({ ref }) => ({
    name: ref("source.wine_name"),
    stock: ref("source.stock_delta"),
  }))
  .whenMatchedAnd(
    (eb) => eb("target.stock", "+", eb.ref("source.stock_delta")),
    ">",
    0,
  )
  .thenUpdateSet("stock", (eb) =>
    eb("target.stock", "+", eb.ref("source.stock_delta")),
  )
  .whenMatched()
  .thenDelete()
  .executeTakeFirstOrThrow()`