# Dialects

A dialect is the glue between Kysely and the underlying database engine. Check the [API docs](https://kysely-org.github.io/kysely-apidoc/interfaces/Dialect.html) to learn how to build your own.

## Core dialects

| Dialect | Link |
| --- | --- |
| PostgreSQL | https://kysely-org.github.io/kysely-apidoc/classes/PostgresDialect.html |
| MySQL | https://kysely-org.github.io/kysely-apidoc/classes/MysqlDialect.html |
| Microsoft SQL Server (MSSQL) | https://kysely-org.github.io/kysely-apidoc/classes/MssqlDialect.html |
| SQLite | https://kysely-org.github.io/kysely-apidoc/classes/SqliteDialect.html |

## Organization dialects

| Dialect | Link |
| --- | --- |
| Postgres.js | https://github.com/kysely-org/kysely-postgres-js |
| SingleStore Data API | https://github.com/kysely-org/kysely-singlestore |

## Community dialects

| Dialect                       | Link                                                                        |
|-------------------------------|-----------------------------------------------------------------------------|
| PlanetScale Serverless Driver | https://github.com/depot/kysely-planetscale                                 |
| Cloudflare D1                 | https://github.com/aidenwallis/kysely-d1                                    |
| AWS RDS Data API              | https://github.com/serverless-stack/kysely-data-api                         |
| SurrealDB                     | https://github.com/igalklebanov/kysely-surrealdb                            |
| Neon                          | https://github.com/seveibar/kysely-neon                                     |
| Xata                          | https://github.com/xataio/client-ts/tree/main/packages/plugin-client-kysely |
| AWS S3 Select                 | https://github.com/igalklebanov/kysely-s3-select                            |
| libSQL/sqld                   | https://github.com/libsql/kysely-libsql                                     |
| Fetch driver                  | https://github.com/andersgee/kysely-fetch-driver                            |
| SQLite WASM                   | https://github.com/DallasHoff/sqlocal                                       |
| Deno SQLite                   | https://gitlab.com/soapbox-pub/kysely-deno-sqlite                           |
| TiDB Cloud Serverless Driver  | https://github.com/tidbcloud/kysely                                         |
| Capacitor SQLite Kysely       | https://github.com/DawidWetzler/capacitor-sqlite-kysely                     |
| BigQuery                      | https://github.com/maktouch/kysely-bigquery                                 |
| Clickhouse                    | https://github.com/founderpathcom/kysely-clickhouse                         |
