package sys

type SysSection struct {
	IfacePrefix       []string            `yaml:"ifacePrefix"`
	MountPoint        []string            `yaml:"mountPoint"`
	MountIgnorePrefix []string            `yaml:"mountIgnorePrefix"`
	IgnoreMetrics     []string            `yaml:"ignoreMetrics"`
	IgnoreMetricsMap  map[string]struct{} `yaml:"-"`
	NtpServers        []string            `yaml:"ntpServers"`
	Plugin            string              `yaml:"plugin"`
	Interval          int                 `yaml:"interval"`
	Timeout           int                 `yaml:"timeout"`
}

var Config SysSection

func Init(s SysSection) {
	Config = s

	l := len(Config.IgnoreMetrics)
	m := make(map[string]struct{}, l)
	for i := 0; i < l; i++ {
		m[Config.IgnoreMetrics[i]] = struct{}{}
	}

	Config.IgnoreMetricsMap = m
}
