import { Component, NgModule, ViewChild } from '@angular/core';
import { AlertController, DeepLinkConfig, IonicApp, IonicModule, App, NavController, NavParams, ModalController, ViewController, Tabs, Tab } from '../../../../../ionic-angular';


// @DeepLink({ name: 'sign-in' })
@Component({
  templateUrl: './signIn.html'
})
export class SignIn {
  tabsPage = TabsPage;
}


@Component({
  templateUrl: './modalChat.html'
})
export class ChatPage {

  constructor(public viewCtrl: ViewController) {}

  ionViewDidLoad() {
    console.log('ChatPage, ionViewDidLoad');
  }

  ionViewWillUnload() {
    console.log('ChatPage, ionViewWillUnload');
  }
}


// @DeepLink({ name: 'tabs' })
@Component({
  templateUrl: './tabs.html'
})
export class TabsPage {
  showTab: boolean = false;
  rootPage1 = Tab1Page1;
  rootPage2 = Tab2Page1;
  rootPage3 = Tab3Page1;

  @ViewChild(Tabs) tabs: Tabs;

  constructor(
    public navCtrl: NavController,
    public modalCtrl: ModalController,
    public params: NavParams,
    public alertCtrl: AlertController
  ) { }

  ngAfterViewInit() {
    this.tabs.ionChange.subscribe((tab: Tab) => {
      console.log('tabs.ionChange.subscribe', tab.index);
    });
  }

  onTabChange(tab: Tab) {
    this.showTab = tab.index !== 1;

    // wired up through the template
    // <ion-tabs (ionChange)="onTabChange()">
    console.log('onTabChange');
  }

  logout() {
    this.navCtrl.pop().catch(() => {
      console.log('Cannot go back.');
    });
  }

  ionViewCanLeave() {
    return new Promise((resolve, reject) => {
      let alert = this.alertCtrl.create({
        title: 'Log out',
        subTitle: 'Are you sure you want to log out?',
        buttons: [
          {
            text: 'No',
            role: 'cancel',
            handler: () => {
              reject();
            }
          },
          {
            text: 'Yes',
            handler: () => {
              alert.dismiss().then(() => {
                resolve();
              });
              return false;
            }
          }
        ]
      });
      alert.present();
    });
  }

  chat() {
    console.log('Chat clicked!');
    this.modalCtrl.create(ChatPage).present();
  }

  ionViewWillEnter() {
    console.log('TabsPage, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('TabsPage, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('TabsPage, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('TabsPage, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('TabsPage, ionViewWillUnload');
  }
}


//
// tab 1
//
// @DeepLink({ name: 'tab1-page1' })
@Component({
  templateUrl: './tab1page1.html'
})
export class Tab1Page1 {
  tab1Page2 = Tab1Page2;
  color: boolean;
  userId: string;

  constructor(public navCtrl: NavController, public app: App, public tabs: Tabs, public params: NavParams) {
    this.userId = params.get('userId');
  }

  goBack() {
    console.log('go back begin');
    this.navCtrl.pop().then((val: any) => {
      console.log('go back completed', val);
    });
  }

  favoritesTab() {
    this.tabs.select(1);
  }

  logout() {
    this.app.getRootNav().setRoot(SignIn, null, { animate: true, direction: 'back' }).catch(() => {
      console.debug('logout cancelled');
    });
  }

  ionViewWillEnter() {
    console.log('Tab1Page1, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('Tab1Page1, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('Tab1Page1, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('Tab1Page1, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('Tab1Page1, ionViewWillUnload');
  }
}


// @DeepLink({ name: 'tab1-page2' })
@Component({
  templateUrl: './tab1page2.html'
})
export class Tab1Page2 {
  tab1Page3 = Tab1Page3;

  constructor(public tabs: Tabs) { }

  favoritesTab() {
    // TODO fix this with tabsHideOnSubPages=true
    this.tabs.select(1);
  }

  ionViewWillEnter() {
    console.log('Tab1Page2, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('Tab1Page2, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('Tab1Page2, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('Tab1Page2, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('Tab1Page2, ionViewWillUnload');
  }
}


// @DeepLink({ name: 'tab1-page3' })
@Component({
  templateUrl: './tab1page3.html'
})
export class Tab1Page3 {

  constructor(public navCtrl: NavController) {}

  ionViewWillEnter() {
    console.log('Tab1Page3, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('Tab1Page3, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('Tab1Page3, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('Tab1Page3, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('Tab1Page3, ionViewWillUnload');
  }
}


//
// tab 2
//
// @DeepLink({ name: 'tab2-page1' })
@Component({
  templateUrl: './tab2page1.html'
})
export class Tab2Page1 {
  tab2Page2 = Tab2Page2;

  ionViewWillEnter() {
    console.log('Tab2Page1, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('Tab2Page1, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('Tab2Page1, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('Tab2Page1, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('Tab2Page1, ionViewWillUnload');
  }
}


// @DeepLink({ name: 'tab2-page2' })
@Component({
  templateUrl: './tab2page2.html'
})
export class Tab2Page2 {
  tab2Page3 = Tab2Page3;

  ionViewWillEnter() {
    console.log('Tab2Page2, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('Tab2Page2, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('Tab2Page2, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('Tab2Page2, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('Tab2Page2, ionViewWillUnload');
  }
}


// @DeepLink({
//   name: 'tab2-page3',
//   defaultHistory: []
// })
@Component({
  templateUrl: './tab2page3.html'
})
export class Tab2Page3 {

  constructor(public navCtrl: NavController) {}

  ionViewWillEnter() {
    console.log('Tab2Page3, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('Tab2Page3, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('Tab2Page3, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('Tab2Page3, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('Tab2Page3, ionViewWillUnload');
  }
}


//
// tab 3
//
// @DeepLink({ name: 'tab3-page1' })
@Component({
  templateUrl: './tab3page1.html'
})
export class Tab3Page1 {

  ionViewWillEnter() {
    console.log('Tab3Page1, ionViewWillEnter');
  }

  ionViewDidEnter() {
    console.log('Tab3Page1, ionViewDidEnter');
  }

  ionViewWillLeave() {
    console.log('Tab3Page1, ionViewWillLeave');
  }

  ionViewDidLeave() {
    console.log('Tab3Page1, ionViewDidLeave');
  }

  ionViewWillUnload() {
    console.log('Tab3Page1, ionViewWillUnload');
  }
}

@Component({
  template: '<ion-nav [root]="rootPage" swipeBackEnabled="false"></ion-nav>'
})
export class E2EApp {
  rootPage = SignIn;
}


export const deepLinkConfig: DeepLinkConfig = {
  links: [
    { component: SignIn, name: 'sign-in' },
    { component: TabsPage, name: 'tabs' },
    { component: Tab1Page1, name: 'tab1-page1' },
    { component: Tab1Page2, name: 'tab1-page2' },
    { component: Tab1Page3, name: 'tab1-page3' },
    { component: Tab2Page1, name: 'tab2-page1' },
    { component: Tab2Page2, name: 'tab2-page2' },
    { component: Tab2Page3, name: 'tab2-page3' },
    { component: Tab3Page1, name: 'tab3-page1' },
  ]
};

@NgModule({
  declarations: [
    E2EApp,
    SignIn,
    ChatPage,
    TabsPage,
    Tab1Page1,
    Tab1Page2,
    Tab1Page3,
    Tab2Page1,
    Tab2Page2,
    Tab2Page3,
    Tab3Page1
  ],
  imports: [
    IonicModule.forRoot(E2EApp, {tabsHideOnSubPages: true}, deepLinkConfig)
  ],
  bootstrap: [IonicApp],
  entryComponents: [
    SignIn,
    ChatPage,
    TabsPage,
    Tab1Page1,
    Tab1Page2,
    Tab1Page3,
    Tab2Page1,
    Tab2Page2,
    Tab2Page3,
    Tab3Page1
  ]
})
export class AppModule {}
