// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package snippets

import (
	"bytes"
	"fmt"
	"testing"

	"github.com/GoogleCloudPlatform/golang-samples/internal/testutil"
)

func Test_tryGemini(t *testing.T) {
	tc := testutil.SystemTest(t)
	buf := &bytes.Buffer{}
	err := tryGemini(buf, tc.ProjectID, "us-central1", "gemini-2.0-flash-001")
	if err != nil {
		t.Errorf("unexpected error: %v", err)
	}
	fmt.Println(buf)
}
