## Description

Fixes #<ISSUE-NUMBER>

Note: Before submitting a pull request, please open an issue for discussion if you are not associated with Google.

## Checklist
- [ ] I have followed [Contributing Guidelines from CONTRIBUTING.MD](https://github.com/GoogleCloudPlatform/golang-samples/blob/main/CONTRIBUTING.md)
- [ ] **Tests** pass:   `go test -v ./..` (see [Testing](https://github.com/GoogleCloudPlatform/golang-samples/blob/main/CONTRIBUTING.md#testing))
- [ ] **Code formatted**:   `gofmt` (see [Formatting](https://github.com/GoogleCloudPlatform/golang-samples/blob/main/CONTRIBUTING.md#formatting))
- [ ] **Vetting** pass:   `go vet` (see [Formatting](https://github.com/GoogleCloudPlatform/golang-samples/blob/main/CONTRIBUTING.md#formatting))
- [ ] These samples need a new **API enabled** in testing projects to pass (let us know which ones)
- [ ] These samples need a new/updated **env vars** in testing projects set to pass (let us know which ones)
- [ ] This sample adds a new sample directory, and I updated the [CODEOWNERS file](https://github.com/GoogleCloudPlatform/golang-samples/blob/main/.github/CODEOWNERS) with the codeowners for this sample
- [ ] This sample adds a new **Product API**, and I updated the [Blunderbuss issue/PR auto-assigner](https://github.com/GoogleCloudPlatform/golang-samples/blob/main/.github/blunderbuss.yml) with the codeowners for this sample
- [ ] Please **merge** this PR for me once it is approved
