# Specification-Driven Development (SDD)

## 權力倒置

數十年來，程式碼一直是王道。規格文件服務於程式碼——它們是我們建立的鷹架，一旦開始「真正的工作」撰寫程式碼時就被丟棄。我們撰寫 PRD 來指導開發、建立設計文件來告知實作、繪製圖表來視覺化架構。但這些總是從屬於程式碼本身。程式碼是真理。其他一切充其量只是善意的想法。程式碼是真相的來源，隨著它向前推進，規格文件很少跟得上步調。由於資產（程式碼）和實作是一體的，在不試圖從程式碼建構的情況下要有平行實作並不容易。

Spec-Driven Development (SDD) 顛覆了這個權力結構。規格文件不為程式碼服務——程式碼為規格文件服務。PRD（Product Requirements Document-Specification）不是實作的指南；它是產生實作的來源。技術計畫不是告知編碼的文件；它們是產生程式碼的精確定義。這不是我們建構軟體方式的漸進式改進。這是對驅動開發要素的根本性重新思考。

規格文件與實作之間的差距從軟體開發誕生以來就一直困擾著整個領域。我們試圖透過更好的文件、更詳細的需求、更嚴格的流程來彌補這個差距。這些方法失敗的原因是它們接受差距是不可避免的。它們試圖縮小差距但從未消除差距。SDD 透過讓規格文件及其從規格文件中產生的具體實作計畫變得可執行來消除差距。當規格文件到實作計畫產生程式碼時，就沒有差距——只有轉換。

這種轉換現在是可能的，因為 AI 可以理解和實作複雜的規格文件，並創建詳細的實作計畫。但是沒有結構的原始 AI 生成會產生混亂。SDD 透過精確、完整且明確到足以產生可運作系統的規格文件和後續實作計畫提供這種結構。規格文件成為主要成品。程式碼成為其在特定語言和 framework 中的表達（作為來自實作計畫的實作）。

在這個新世界中，維護軟體意味著演化規格文件。開發團隊的意圖以自然語言（「**intent-driven development**」）、設計資產、核心原則和其他指導原則來表達。開發的 **lingua franca** 移動到更高層次，程式碼是最後一哩路的方法。

除錯意味著修復產生錯誤程式碼的規格文件和其實作計畫。重構意味著為了清晰而重新組織結構。整個開發工作流程以規格文件作為核心真理來源重新組織，實作計畫和程式碼作為持續重新生成的輸出。用新功能更新應用程式或因為我們是創造性生物而創建新的平行實作，意味著重新審視規格文件並創建新的實作計畫。因此這個過程是 0 -> 1, (1', ..), 2, 3, N。

開發團隊專注於他們的創造力、實驗和批判性思維。

## SDD 實際工作流程

工作流程從一個想法開始——通常是模糊且不完整的。透過與 AI 的反覆對話，這個想法成為一份全面的 PRD。AI 提出澄清問題，識別邊界情況，並幫助定義精確的驗收標準。在傳統開發中可能需要數天的會議和文件工作，在專注的規格文件工作中只需要數小時就能完成。這改變了傳統的 SDLC——需求和設計成為持續的活動，而不是離散的階段。這支援一個**團隊流程**，即團隊審查的規格文件被表達和版本控制，在分支中創建並合併。

當產品經理更新驗收標準時，實作計畫會自動標記受影響的技術決策。當架構師發現更好的模式時，PRD 會更新以反映新的可能性。

在整個規格文件過程中，研究 agent 收集關鍵 context。它們調查 library 相容性、效能基準和安全影響。組織約束被自動發現和應用——你公司的資料庫標準、身份驗證要求和部署政策無縫整合到每個規格文件中。

從 PRD 開始，AI 產生將需求映射到技術決策的實作計畫。每個技術選擇都有記錄在案的理由。每個架構決策都可以追溯到特定需求。在整個過程中，一致性驗證持續改善品質。AI 分析規格文件的模糊性、矛盾和差距——不是作為一次性的關卡，而是作為持續的精煉。

程式碼生成在規格文件及其實作計畫足夠穩定時就開始，但它們不必是「完整的」。早期的生成可能是探索性的——測試規格文件在實踐中是否有意義。領域概念變成資料模型。用戶故事變成 API endpoints。驗收場景變成測試。這透過規格文件合併開發和測試——測試場景不是在程式碼後撰寫的，它們是生成實作和測試的規格文件的一部分。

回饋循環延伸到初始開發之外。生產環境 metrics 和事件不僅觸發 hotfix——它們為下一次重新生成更新規格文件。效能瓶頸成為新的非功能需求。安全漏洞成為影響所有未來生成的約束。規格文件、實作和營運現實之間的這種反覆舞蹈是真正理解出現的地方，也是傳統 SDLC 轉變為持續演進的地方。

## 為什麼 SDD 現在很重要

三個趨勢使 SDD 不僅可能而且必要：

首先，AI 能力已經達到一個門檻，自然語言規格文件可以可靠地生成可運作的程式碼。這不是要取代開發者——而是透過自動化從規格文件到實作的機械翻譯來放大他們的效果。它可以放大探索和創造力，可以輕鬆支援「重新開始」，支援增減和批判性思維。

其次，軟體複雜性持續指數增長。現代系統整合數十個服務、framework 和依賴項。透過手動流程保持所有這些部分與原始意圖一致變得越來越困難。SDD 透過規格文件驅動的生成提供系統性對齊。Framework 可能會演進為提供 AI 優先的支援，而不是人類優先的支援，或圍繞可重用組件進行架構。

第三，變化的步調加速。今天需求的變化比以往任何時候都快得多。轉向不再是例外——而是預期的。現代產品開發要求基於用戶回饋、市場條件和競爭壓力的快速迭代。傳統開發將這些變化視為干擾。每次轉向都需要手動將變化傳播到文件、設計和程式碼中。結果要么是限制速度的緩慢、謹慎更新，要么是累積技術債務的快速、魯莽變化。

SDD 可以支援假設/模擬實驗，「如果我們需要重新實作或改變應用程式以促進銷售更多 T-shirt 的商業需求，我們如何實作和實驗？」。

SDD 將需求變化從障礙轉變為正常工作流程。當規格文件驅動實作時，轉向變成系統性重新生成，而不是手動重寫。改變 PRD 中的核心需求，受影響的實作計畫會自動更新。修改用戶故事，相應的 API endpoints 會重新生成。這不僅關於初始開發——而是關於在不可避免的變化中維持工程速度。

## 核心原則

**規格文件作為 Lingua Franca**：規格文件成為主要成品。程式碼成為其在特定語言和 framework 中的表達。維護軟體意味著演化規格文件。

**可執行的規格文件**：規格文件必須足夠精確、完整且明確，以產生可運作的系統。這消除了意圖與實作之間的差距。

**持續精煉**：一致性驗證持續進行，而非一次性的關卡。AI 作為持續過程分析規格文件的模糊性、矛盾和缺口。

**研究驅動的 Context**：研究 agent 在整個規格文件過程中收集關鍵 context，調查技術選項、效能影響和組織限制。

**雙向回饋**：生產環境的現實告知規格文件演化。指標、事件和營運學習成為規格文件精煉的輸入。

**分支探索**：從同一規格文件產生多種實作方法，以探索不同的最佳化目標——效能、可維護性、使用者體驗、成本。

## 實作方法

今天，實踐 SDD 需要組裝現有工具並在整個過程中保持紀律。這個方法論可以透過以下方式實踐：

- AI 助手進行反覆規格文件開發
- 研究 agent 收集技術 context
- 程式碼生成工具將規格文件轉換為實作
- 適用於規格文件優先工作流程的版本控制系統
- 透過 AI 分析規格文件來進行一致性檢查

關鍵是將規格文件視為真理來源，程式碼作為服務於規格文件而不是相反的生成輸出。

## 透過指令簡化 SDD

SDD 方法論透過三個強大的指令顯著增強，這些指令自動化了規格文件 → 規劃 → 任務分派的工作流程：

### `/specify` 指令

這個指令將簡單的功能描述（用戶提示）轉換為完整的結構化規格文件，並自動進行儲存庫管理：

1. **自動功能編號**：掃描現有規格文件以確定下一個功能編號（例如 001、002、003）
2. **分支創建**：從您的描述生成語義分支名稱並自動創建
3. **基於樣板的生成**：複製並自定義功能規格文件樣板以符合您的需求
4. **目錄結構**：為所有相關文件創建適當的 `specs/[branch-name]/` 結構

### `/plan` 指令

一旦功能規格文件存在，這個指令就會創建全面的實作計畫：

1. **規格文件分析**：讀取並理解功能需求、用戶故事和驗收標準
2. **憲法合規性**：確保與專案憲法和架構原則對齊
3. **技術轉換**：將業務需求轉換為技術架構和實作細節
4. **詳細文件**：為資料模型、API 合約和測試場景生成支援文件
5. **快速開始驗證**：產生捕捉關鍵驗證場景的快速開始指南

### `/tasks` 指令

計畫創建後，這個指令分析計畫和相關設計文件來生成可執行的任務清單：

1. **輸入**：讀取 `plan.md`（必需）以及（如果存在）`data-model.md`、`contracts/` 和 `research.md`
2. **任務衍生**：將合約、實體和場景轉換為具體任務
3. **平行化**：標記獨立任務 `[P]` 並概述安全的平行群組
4. **輸出**：在功能目錄中寫入 `tasks.md`，準備由 Task agent 執行

### 範例：建立 Chat 功能

以下是這些指令如何轉變傳統開發工作流程：

**傳統方法：**

```text
1. 在文件中撰寫 PRD（2-3 小時）
2. 創建設計文件（2-3 小時）
3. 手動設置專案結構（30 分鐘）
4. 撰寫技術規格文件（3-4 小時）
5. 創建測試計畫（2 小時）
總計：約 12 小時的文件工作
```

**使用指令的 SDD 方法：**

```bash
# 步驟 1：創建功能規格文件（5 分鐘）
/specify Real-time chat system with message history and user presence

# 這會自動：
# - 創建分支 "003-chat-system"
# - 生成 specs/003-chat-system/spec.md
# - 用結構化需求填充它

# 步驟 2：生成實作計畫（5 分鐘）
/plan WebSocket for real-time messaging, PostgreSQL for history, Redis for presence

# 步驟 3：生成可執行任務（5 分鐘）
/tasks

# 這會自動創建：
# - specs/003-chat-system/plan.md
# - specs/003-chat-system/research.md (WebSocket library 比較)
# - specs/003-chat-system/data-model.md (Message 和 User schemas)
# - specs/003-chat-system/contracts/ (WebSocket 事件，REST endpoints)
# - specs/003-chat-system/quickstart.md (關鍵驗證場景)
# - specs/003-chat-system/tasks.md (從計畫衍生的任務清單)
```

在 15 分鐘內，您擁有：

- 完整的功能規格文件，包含用戶故事和驗收標準
- 詳細的實作計畫，包含技術選擇和理由
- 準備好進行程式碼生成的 API 合約和資料模型
- 自動化和手動測試的全面測試場景
- 在功能分支中適當版本控制的所有文件

### 結構化自動化的力量

這些指令不僅節省時間——它們強制一致性和完整性：

1. **沒有遺漏的細節**：樣板確保考慮每個方面，從非功能需求到錯誤處理
2. **可追溯的決策**：每個技術選擇都可以追溯到特定需求
3. **活文件**：規格文件與程式碼保持同步，因為它們生成程式碼
4. **快速迭代**：在幾分鐘內更改需求並重新生成計畫，而不是幾天

這些指令透過將規格文件視為可執行的成品而不是靜態文件來體現 SDD 原則。它們將規格文件過程從必要之惡轉變為開發的驅動力。

### 樣板驅動的品質：結構如何約束 LLM 以獲得更好的結果

這些指令的真正力量不僅在於自動化，還在於樣板如何引導 LLM 行為朝向更高品質的規格文件。樣板充當精密的提示，以有效的方式約束 LLM 的輸出：

#### 1. **防止過早的實作細節**

功能規格文件樣板明確指示：

```text
- ✅ 專注於用戶需要什麼以及為什麼
- ❌ 避免如何實作（沒有技術堆疊、API、程式碼結構）
```

這個約束強制 LLM 維持適當的抽象層級。當 LLM 可能自然地跳到「使用 React 和 Redux 實作」時，樣板讓它專注於「用戶需要其資料的即時更新」。這種分離確保規格文件即使在實作技術變化時也保持穩定。

#### 2. **強制明確的不確定性標記**

兩個樣板都強制使用 `[NEEDS CLARIFICATION]` 標記：

```text
從用戶提示創建此規格文件時：
1. **標記所有模糊之處**：使用 [NEEDS CLARIFICATION: 具體問題]
2. **不要猜測**：如果提示沒有指定某些內容，請標記它
```

這防止了 LLM 做出看似合理但可能不正確假設的常見行為。不是猜測「登入系統」使用電子郵件/密碼驗證，LLM 必須將其標記為 `[NEEDS CLARIFICATION: auth method not specified - email/password, SSO, OAuth?]`。

#### 3. **透過檢查清單的結構化思考**

樣板包含作為規格文件「單元測試」的全面檢查清單：

```markdown
### 需求完整性
- [ ] 沒有 [NEEDS CLARIFICATION] 標記剩餘
- [ ] 需求是可測試且明確的
- [ ] 成功標準是可衡量的
```

這些檢查清單強制 LLM 系統地自我審查其輸出，捕捉可能漏掉的差距。這就像給 LLM 一個品質保證框架。

#### 4. **透過關卡的憲法合規性**

實作計畫樣板透過階段關卡強制架構原則：

```markdown
### 階段 -1：實作前關卡
#### 簡單性關卡（第七條）
- [ ] 使用 ≤3 個專案？
- [ ] 沒有未來證明？
#### 反抽象關卡（第八條）
- [ ] 直接使用 framework？
- [ ] 單一模型表示？
```

這些關卡透過讓 LLM 明確證明任何複雜性來防止過度工程。如果關卡失敗，LLM 必須在「複雜性追踪」部分記錄原因，為架構決策創建問責制。

#### 5. **階層詳細管理**

樣板強制適當的資訊架構：

```text
**重要**：這個實作計畫應該保持高層次和可讀性。
任何程式碼範例、詳細演算法或廣泛的技術規格文件
必須放在適當的 `implementation-details/` 檔案中
```

這防止規格文件變成不可讀程式碼堆積的常見問題。LLM 學會維持適當的詳細層級，將複雜性提取到單獨檔案中，同時保持主要文件的可導航性。

#### 6. **測試優先思維**

實作樣板強制測試優先開發：

```text
### 檔案創建順序
1. 創建 `contracts/` 與 API 規格文件
2. 按順序創建測試檔案：contract → integration → e2e → unit
3. 創建原始檔案讓測試通過
```

這個順序約束確保 LLM 在實作前考慮可測試性和合約，導致更強健和可驗證的規格文件。

#### 7. **防止投機功能**

樣板明確阻止投機：

```text
- [ ] 沒有投機或「可能需要」的功能
- [ ] 所有階段都有明確的前提條件和交付成果
```

這阻止 LLM 添加使實作複雜化的「很好有」功能。每個功能都必須可以追溯到具有明確驗收標準的具體用戶故事。

### 複合效應

這些約束協同工作產生的規格文件具有以下特性：

- **完整性**：檢查清單確保沒有遺忘任何事項
- **明確性**：強制澄清標記突出不確定性
- **可測試性**：測試優先思維融入流程
- **可維護性**：適當的抽象層級和資訊階層
- **可實作性**：具有具體交付成果的明確階段

樣板將 LLM 從創意作家轉變為有紀律的規格文件工程師，將其能力導向產生始終如一的高品質、可執行規格文件，真正驅動開發。

## 憲法基礎：強化架構紀律

SDD 的核心是一部憲法——一套管理規格文件如何成為程式碼的不變原則。憲法（`memory/constitution.md`）充當系統的架構 DNA，確保每個生成的實作保持一致性、簡單性和品質。

### 開發的九個條款

憲法定義了九個條款，塑造開發過程的每個方面：

#### 條款一：Library 優先原則

每個功能都必須以獨立 library 開始——無例外。這從一開始就強制模組化設計：

```text
Specify 中的每個功能都必須以獨立 library 的形式開始存在。
任何功能都不應直接在應用程式碼中實作，
必須先抽象為可重用的 library 組件。
```

這個原則確保規格文件生成模組化、可重用的程式碼，而不是單體應用程式。當 LLM 生成實作計畫時，它必須將功能結構化為具有清晰邊界和最小依賴的 library。

#### 條款二：CLI 介面要求

每個 library 都必須透過命令列介面暴露其功能：

```text
所有 CLI 介面必須：
- 接受文字作為輸入（透過 stdin、參數或檔案）
- 產生文字作為輸出（透過 stdout）
- 支援 JSON 格式進行結構化資料交換
```

這強制可觀察性和可測試性。LLM 無法將功能隱藏在不透明的類別中——一切都必須透過基於文字的介面進行存取和驗證。

#### 條款三：測試優先命令

最具變革性的條款——程式碼之前必須有測試：

```text
這是不可協商的：所有實作都必須遵循嚴格的測試驅動開發。
在以下條件滿足之前不得撰寫實作程式碼：
1. 撰寫單元測試
2. 測試經用戶驗證和批准
3. 確認測試失敗（紅燈階段）
```

這完全顛覆了傳統的 AI 程式碼生成。不是生成程式碼並希望它能運作，LLM 必須首先生成定義行為的全面測試，獲得批准，然後才生成實作。

#### 條款七和八：簡單性和反抽象

這些配對條款對抗過度工程：

```text
第 7.3 節：最小專案結構
- 初始實作最多 3 個專案
- 額外專案需要記錄在案的證明

第 8.1 節：Framework 信任
- 直接使用 framework 功能而不是包裝它們
```

當 LLM 可能自然地創建精巧抽象時，這些條款強制它證明每層複雜性。實作計畫樣板的「階段 -1 關卡」直接強制這些原則。

#### 條款九：整合優先測試

優先考慮真實世界測試而非孤立單元測試：

```text
測試必須使用現實環境：
- 偏好真實資料庫而非 mock
- 使用實際服務實例而非 stub
- 實作前必須進行合約測試
```

這確保生成的程式碼在實踐中有效，而不僅僅在理論上。

### 透過樣板強化憲法

實作計畫樣板透過具體檢查點將這些條款具體化：

```markdown
### 階段 -1：實作前關卡
#### 簡單性關卡（條款七）
- [ ] 使用 ≤3 個專案？
- [ ] 沒有未來證明？

#### 反抽象關卡（條款八）
- [ ] 直接使用 framework？
- [ ] 單一模型表示？

#### 整合優先關卡（條款九）
- [ ] 合約已定義？
- [ ] 合約測試已撰寫？
```

這些關卡充當架構原則的編譯時檢查。LLM 無法繼續進行，除非通過關卡或在「複雜性追踪」部分記錄合理的例外。

### 不變原則的力量

憲法的力量在於其不變性。雖然實作細節可以演進，但核心原則保持不變。這提供：

1. **跨時間一致性**：今天生成的程式碼遵循與明年生成程式碼相同的原則
2. **跨 LLM 一致性**：不同的 AI 模型產生架構相容的程式碼
3. **架構完整性**：每個功能強化而不是破壞系統設計
4. **品質保證**：測試優先、library 優先和簡單性原則確保可維護的程式碼

### 憲法演化

雖然原則是不變的，但其應用可以演進：

```text
第 4.2 節：修正流程
對此憲法的修改需要：
- 明確記錄變更理由
- 專案維護者審查和批准
- 向後相容性評估
```

這允許方法論學習和改進，同時保持穩定性。憲法展示其自身的演進，帶有日期的修正案，證明原則如何基於實際經驗進行精煉。

### 超越規則：開發哲學

憲法不僅是規則手冊——它是塑造 LLM 如何思考程式碼生成的哲學：

- **可觀察性勝過不透明性**：一切都必須透過 CLI 介面可檢查
- **簡單性勝過聰明**：從簡單開始，只有在證明必要時才增加複雜性
- **整合勝過隔離**：在真實環境中測試，而不是人工環境
- **模組化勝過單體**：每個功能都是具有清晰邊界的 library

透過將這些原則嵌入規格文件和規劃過程，SDD 確保生成的程式碼不僅功能正常——而且可維護、可測試且架構健全。憲法將 AI 從程式碼生成器轉變為尊重並強化系統設計原則的架構夥伴。

## 變革

這不是要取代開發者或自動化創造力。這是透過自動化機械轉換來放大人類能力。這是創建一個緊密的回饋循環，讓規格文件、研究和程式碼一起演進，每次迭代都帶來更深入的理解和意圖與實作之間更好的對齊。

軟體開發需要更好的工具來維持意圖與實作之間的對齊。SDD 透過生成程式碼而不僅僅是指導程式碼的可執行規格文件，提供實現這種對齊的方法論。
