package main

import (
	"net/http"

	"github.com/jmpsec/osctrl/settings"
	"github.com/jmpsec/osctrl/utils"
)

const (
	metricAdminReq  = "admin-req"
	metricAdminErr  = "admin-err"
	metricAdminOK   = "admin-ok"
	metricJSONReq   = "admin-json-req"
	metricJSONErr   = "admin-json-err"
	metricJSONOK    = "admin-json-ok"
	metricTokenReq  = "admin-token-req"
	metricTokenErr  = "admin-token-err"
	metricTokenOK   = "admin-token-ok"
	metricHealthReq = "health-req"
	metricHealthOK  = "health-ok"
)

// Empty default osquery configuration
const emptyConfiguration string = "data/osquery-empty.json"

// Handle health requests
func healthHTTPHandler(w http.ResponseWriter, r *http.Request) {
	incMetric(metricHealthReq)
	utils.DebugHTTPDump(r, settingsmgr.DebugHTTP(settings.ServiceAdmin), true)
	// Send response
	w.Header().Set(utils.ContentType, utils.JSONApplicationUTF8)
	w.WriteHeader(http.StatusOK)
	_, _ = w.Write([]byte("✅"))
	incMetric(metricHealthOK)
}

// Handle error requests
func errorHTTPHandler(w http.ResponseWriter, r *http.Request) {
	utils.DebugHTTPDump(r, settingsmgr.DebugHTTP(settings.ServiceAdmin), true)
	// Send response
	w.Header().Set(utils.ContentType, utils.JSONApplicationUTF8)
	w.WriteHeader(http.StatusInternalServerError)
	_, _ = w.Write([]byte("oh no..."))
}

// Handle forbidden error requests
func forbiddenHTTPHandler(w http.ResponseWriter, r *http.Request) {
	utils.DebugHTTPDump(r, settingsmgr.DebugHTTP(settings.ServiceAdmin), true)
	// Send response
	w.WriteHeader(http.StatusForbidden)
	_, _ = w.Write([]byte("❌"))
}

// Handler for the favicon
func faviconHandler(w http.ResponseWriter, r *http.Request) {
	utils.DebugHTTPDump(r, settingsmgr.DebugHTTP(settings.ServiceAdmin), false)
	w.Header().Set("Content-Type", "image/png")
	http.ServeFile(w, r, "./static/favicon.png")
}
