## Contributing

Like any other open source projects, there are multiple ways to contribute to osctrl:

* As a developer, depending on your skills and experience,
* As a user who enjoys the project and wants to help.

##### Reporting Bugs

If you found something broken or not working properly, feel free to create an issue in Github with as much information as possible, such as logs and how to reproduce the problem. Before opening the issue, make sure that:

* You have read this documentation,
* You are using the latest stable version of osctrl,
* You already searched other issues to see if your problem or request was already reported.

##### Improving the Documentation

You can improve this documentation by forking its repository, updating the content and sending a pull request.


#### We ❤️ Pull Requests

A pull request does not need to be a fix for a bug or implementing something new. Software can always be improved, legacy code removed and tests are always welcome!

Please do not be afraid of contributing code, make sure it follows these rules:

* Your code compiles, does not break any of the existing code in the master branch and does not cause conflicts,
* The code is readable and has comments, that aren’t superfluous or unnecessary,
* An overview or context is provided as body of the Pull Request. It does not need to be too extensive.

Extra points if your code comes with tests!