# Command Line Profiler

Allows a user to analyze trace files generated by MediaPipe from the command
line. If you would prefer to see this information visually (or if you can't
build the tool), you can see the same information within viz.mediapipe.dev.
For more information on this, see [Profile Visualization](https://docs.google.com/document/d/1inBoRzKDyKEjtVws8Seceoa0xRU3mqpPgM_myDBilS4/edit#heading=h.bnft45odm046) at go/mediapipe-profiler-guide

See go/mediapipe-profiler-guide for a detailed user's guide.

---

## Building and Executing

Navigate to:

    //mediapipe/framework/profiler/reporter

To run:

    bazel run :print_profile

To test:

    bazel test :reporter_test

To print out the time columns and the total columns (as an example):

    bazel run :print_profile -- --cols "*time*,*total*" --logfiles "<path-to-log>,<path-to-another-log>"


---

### print_profile [OPTION]... [FILE]...
> Extract information from a set of MediaPipe trace files.

**--compact**
> print_profile will create lanes for each column, adding white space so that
everything is easily readable. This option trims out any extra whitespace.

**--cols**
> Column separated set of columns to be shown. Omit to show everything. The user
can use asterisks to match zero or more characters, or question marks to match a
single character. (e.g., "time_*" will match "time_mean", "time_stddev", and so
on).  "calculator" is always shown first.

> Columns are listed below.

#### Calculator Columns:

**calculator**
> The name of the calculator

**fps**
> The number of frames that this calculator can generate each second, on
average. 1 / (latency_mean + time_mean) (Units are 1 / second).

**frequency**

> The rate that this calculator was asked to process packets per second.
(Computed by # of calls total / (last_call_time - first_call_time)).  (Units are
1 / second)

**counter**
> Number of times process() was called on the calculator. If the calculator
generated outputs, then it will be reflected in "completed." If it did not, then
this will be reflected in "dropped".

**dropped**
> Number of times the calculator was called but did not produce an output.

**completed**
> Number of times that this calculator was asked to process inputs after which
it generated outputs.

**processing_rate**
> 1E+6 / time_mean.  The number of times per second this calculator could run
process, on average.  (Units are 1 / second).

**thread_count**
> The number of threads that made use of each calculator.

**time_mean**
> Average time spent within a calculator (in microseconds).

**time_stddev**
> Standard deviation of time_mean (in microseconds).

**time_total**
> Total time spent within a calculator (in microseconds).

**time_percent**
> Percent of total time spent within a calculator.

**input_latency_mean**
> Average latency between earliest input packet and when calculator actually
starts processing (in microseconds).

**input_latency_stddev**
> Standard deviation of input_latency_mean (in microseconds).

**input_latency_total**
> Total accumulated input_latency (in microseconds).
