# Соглашения об именах

!> Следующие соглашения об именах являются просто рекомендациями и не являются обязательными. Не стесняйтесь использовать любые соглашения об именах, которые вы предпочитаете. Вы можете обнаружить, что некоторые примеры/документация не соответствуют соглашениям об именах в основном для простоты/краткости. Эти соглашения настоятельно рекомендуются для больших проектов с несколькими разработчиками.

## Именование событий

> События должны быть названы в **прошедшем времени**, потому что события - это вещи, которые уже произошли с точки зрения блока.

### Анатомия имен событий

`BlocSubject` + `Noun (optional)` + `Verb (event)`

?> События начальной загрузки должны следовать соглашению: `BlocSubject` + `Started`

#### Примеры событий

✅ **Хорошо**

`CounterStarted`
`CounterIncremented`
`CounterDecremented`
`CounterIncrementRetried`

❌ **Плохо**

`Initial`
`CounterInitialized`
`Increment`
`DoIncrement`
`IncrementCounter`

## Именование состояний

> Имена состояний должны быть существительными, потому что состояние - это просто снимок в определенный момент времени.

### Анатомия имен состояний

`BlocSubject` + `Verb (action)` + `State`

?> `State` должен быть одним из следующих: `Initial` | `Success` | `Failure` | `InProgress` и
начальные состояния должны следовать соглашению: `BlocSubject` + `Initial`.

#### Примеры состояний

✅ **Хорошо**

`CounterInitial`
`CounterLoadInProgress`
`CounterLoadSuccess`
`CounterLoadFailure`

❌ **Плохо**

`Initial`
`Loading`
`Success`
`Succeeded`
`Loaded`
`Failure`
`Failed`
