import { dirname } from "path";
import { fileURLToPath } from "url";
import { FlatCompat } from "@eslint/eslintrc";

const __filename = fileURLToPath(import.meta.url);
const __dirname = dirname(__filename);

const compat = new FlatCompat({
  baseDirectory: __dirname,
});

const eslintConfig = [
  ...compat.extends(
    "next/core-web-vitals",
    "next/typescript",
    "plugin:prettier/recommended",
    "plugin:@typescript-eslint/recommended",
  ),
  ...compat.plugins(
    '@typescript-eslint/eslint-plugin',
    'unused-imports',
    "eslint-plugin-react"
  ),
  {
    rules: {
      '@typescript-eslint/interface-name-prefix': 'off',
      '@typescript-eslint/explicit-function-return-type': 'off',
      '@typescript-eslint/explicit-module-boundary-types': 'off',
      '@typescript-eslint/no-explicit-any': 'off',
      "unused-imports/no-unused-imports": "error",
      "@typescript-eslint/no-empty-object-type": "off",
      "@typescript-eslint/no-unused-vars": "warn",
      "prettier/prettier": ["error", { "endOfLine": "auto" }],
      "@typescript-eslint/ban-ts-comment": "off",
      "react/display-name": "off",
      "react-hooks/rules-of-hooks": "off"
    },
  }
];

export default eslintConfig;
