export const NatsApi = {
  user: {
    user: {
      createUserByMail: 'user.user.createUserByMail',
      generatePopCode: 'user.user.generatePopCode',
      getUserByPopularizeCode: 'user.user.getUserByPopularizeCode',
      getUserInfoById: 'user.user.getUserInfoById',
      getUserInfoByMail: 'user.user.getUserInfoByMail',
      updateUserPassword: 'user.user.updateUserPassword',
      updateUserInfo: 'user.user.updateUserInfo',
      updateUserStatus: 'user.user.updateUserStatus',
      getUserInfoByGoogle: 'user.user.getUserInfoByGoogle',
    },
    vip: {
      set: 'user.vip.set',
    },
    task: {
      list: 'user.task.list',
    },
  },
  account: {
    account: {
      create: 'account.account.create',
      getUserAccounts: 'account.account.getUserAccounts',
      getAccountInfoById: 'account.account.getAccountInfoById',
      updateAccountInfo: 'account.account.updateAccountInfo',
      updateAccountStatistics: 'account.account.updateAccountStatistics',
      updateAccountStatus: 'account.account.updateAccountStatus',
      getAccountListByIds: 'account.account.getAccountListByIds',
      getUserAccountCount: 'account.account.getUserAccountCount',
      deleteUserAccount: 'account.account.deleteUserAccount',
      deleteUserAccounts: 'account.account.deleteUserAccounts',
      getAccountByParam: 'account.account.getAccountByParam',
    },
    group: {
      create: 'account.group.create',
      deleteList: 'account.group.deleteList',
      getList: 'account.group.getList',
      update: 'account.group.update',
    },
    fingerprint: {
      generateFingerprint: 'account.fingerprint.generateFingerprint',
    },
  },
  channel: {
    dataCube: {
      getAccountDataCube: 'channel.dataCube.getAccountDataCube',
      getAccountDataBulk: 'channel.dataCube.getAccountDataBulk',
      getArcDataCube: 'channel.dataCube.getArcDataCube',
      getArcDataBulk: 'channel.dataCube.getArcDataBulk',
    },
    interact: {
      addArcComment: 'channel.interact.addArcComment',
      getArcCommentList: 'channel.interact.getArcCommentList',
      replyComment: 'channel.interact.replyComment',
      delComment: 'channel.interact.delComment',
    },
    skKey: {
      create: 'channel.skKey.create',
      del: 'channel.skKey.del',
      upInfo: 'channel.skKey.upInfo',
      getInfo: 'channel.skKey.getInfo',
      list: 'channel.skKey.list',
      addRefAccount: 'channel.skKey.addRefAccount',
      delRefAccount: 'channel.skKey.delRefAccount',
      getRefAccountList: 'channel.skKey.getRefAccountList',
    },
  },
  plat: {
    publish: {
      create: 'plat.publish.create',
      createRecord: 'publish.publishRecord.createRecord',
      run: 'publish.task.run',
      getList: 'publish.publishRecord.list',
      changeTime: 'publish.task.changeTime',
      delete: 'publish.task.delete',
      nowPubTask: 'publish.task.nowPubTask',
    },
    bilibili: {
      getHeader: 'plat.bilibili.getHeader',
      getAccountAuthInfo: 'plat.bilibili.getAccountAuthInfo',
      auth: 'plat.bilibili.auth',
      createAccountAndSetAccessToken:
        'plat.bilibili.createAccountAndSetAccessToken',
      videoInit: 'plat.bilibili.videoInit',
      uploadVideoPart: 'plat.bilibili.uploadVideoPart',
      videoComplete: 'plat.bilibili.videoComplete',
      coverUpload: 'plat.bilibili.coverUpload',
      uploadLitVideo: 'plat.bilibili.uploadLitVideo',
      archiveAddByUtoken: 'plat.bilibili.archiveAddByUtoken',
      archiveTypeList: 'plat.bilibili.archiveTypeList',
      getAuthInfo: 'plat.bilibili.getAuthInfo',
      archiveList: 'plat.bilibili.archiveList',
      userStat: 'channel.bilibili.dataCube.userStat',
      arcStat: 'plat.bilibili.arcStat',
      arcIncStat: 'plat.bilibili.arcIncStat',
    },
    kwai: {
      auth: 'plat.kwai.auth',
      getAuthInfo: 'plat.kwai.getAuthInfo',
      createAccountAndSetAccessToken:
        'plat.kwai.createAccountAndSetAccessToken',
    },
    wxGzh: {
      createAccountAndSetAccessToken:
        'channel.wxPlat.createAccountAndSetAccessToken',
      updatePublishRecord:
        'channel.wxPlat.updatePublishRecord',
      auth: 'plat.wxPlat.auth',
      getAccountAuthInfo: 'plat.wxPlat.getAccountAuthInfo',
      getAuthInfo: 'plat.wxPlat.getAuthInfo',
      getUserCumulate: 'plat.wxPlat.getUserCumulate',
      getUserRead: 'plat.wxPlat.getUserRead',
    },
    youtube: {
      getAccountAuthInfo: 'plat.youtube.getAccountAuthInfo',
      authUrl: 'plat.youtube.authUrl',
      setAccessToken: 'plat.youtube.setAccessToken',
      getAuthInfo: 'plat.youtube.getAuthInfo',
      isAuthorized: 'plat.youtube.isAuthorized',
      refreshToken: 'plat.youtube.refreshToken',
      getVideoCategories: 'plat.youtube.getVideoCategories',
      getVideosList: 'plat.youtube.getVideosList',
      uploadVideo: 'plat.youtube.uploadVideo',
      initVideoUpload: 'plat.youtube.initVideoUpload',
      uploadVideoPart: 'plat.youtube.uploadVideoPart',
      videoComplete: 'plat.youtube.videoComplete',
      getCommentsList: 'plat.youtube.getCommentsList',
      insertCommentThreads: 'plat.youtube.insertCommentThreads',
      getCommentThreadsList: 'plat.youtube.getCommentThreadsList',
      insertComment: 'plat.youtube.insertComment',
      updateComment: 'plat.youtube.updateComment',
      deleteComment: 'plat.youtube.deleteComment',
      setModerationStatusComments: 'plat.youtube.setModerationStatusComments',
      setVideoRate: 'plat.youtube.setVideoRate',
      getVideoRate: 'plat.youtube.getVideoRate',
      deleteVideo: 'plat.youtube.deleteVideo',
      updateVideo: 'plat.youtube.updateVideo',
      createPlaylist: 'plat.youtube.createPlaylist',
      updatePlaylist: 'plat.youtube.updatePlaylist',
      getPlayList: 'plat.youtube.getPlayList',
      deletePlaylist: 'plat.youtube.deletePlaylist',
      insertPlayListItems: 'plat.youtube.insertPlayListItems',
      updatePlayListItems: 'plat.youtube.updatePlayListItems',
      getPlayListItems: 'plat.youtube.getPlayListItems',
      deletePlayListItems: 'plat.youtube.deletePlayListItems',
      getChannelsList: 'plat.youtube.getChannelsList',
      getChannelsSectionsList: 'plat.youtube.getChannelsSectionsList',
    },
    pinterest: {
      getUserAccount: 'plat.pinterest.getUserAccount',
      createAdAccount: 'plat.pinterest.createAdAccount',
      getAdAccountById: 'plat.pinterest.getAdAccountById',
      getAdAccountList: 'plat.pinterest.getAdAccountList',
      createBoard: 'plat.pinterest.createBoard',
      getBoardList: 'plat.pinterest.getBoardList',
      getBoardById: 'plat.pinterest.getBoardById',
      delBoardById: 'plat.pinterest.delBoardById',
      createPin: 'plat.pinterest.createPin',
      getPinById: 'plat.pinterest.getPinById',
      getPinList: 'plat.pinterest.getPinList',
      delPinById: 'plat.pinterest.delPinById',
      getAuth: 'plat.pinterest.getAuth',
      checkAuth: 'plat.pinterest.checkAuth',
      authWebhook: 'plat.pinterest.authWebhook',
    },
    tiktok: {
      authUrl: 'plat.tiktok.authUrl',
      getAuthInfo: 'plat.tiktok.getAuthInfo',
      createAccountAndSetAccessToken:
        'plat.tiktok.createAccountAndSetAccessToken',
      refreshAccessToken: 'plat.tiktok.refreshAccessToken',
      revokeAccessToken: 'plat.tiktok.revokeAccessToken',
      getCreatorInfo: 'plat.tiktok.getCreatorInfo',
      initVideoPublish: 'plat.tiktok.initVideoPublish',
      initPhotoPublish: 'plat.tiktok.initPhotoPublish',
      getPublishStatus: 'plat.tiktok.getPublishStatus',
      uploadVideoFile: 'plat.tiktok.uploadVideoFile',
      handleWebhookEvent: 'publish.tiktok.post.webhook',
    },
    twitter: {
      authUrl: 'plat.twitter.authUrl',
      getAuthInfo: 'plat.twitter.getAuthInfo',
      createAccountAndSetAccessToken:
        'plat.twitter.createAccountAndSetAccessToken',
    },
    meta: {
      authUrl: 'plat.meta.authUrl',
      getAuthInfo: 'plat.meta.getAuthInfo',
      createAccountAndSetAccessToken:
        'plat.meta.createAccountAndSetAccessToken',
      getFacebookPages: 'plat.meta.facebook.pages',
      getFacebookPagePublishedPosts: 'plat.meta.facebook.page.published_posts',
      getFacebookPageInsights: 'plat.meta.facebook.page.insights',
      selectFacebookPages: 'plat.meta.facebook.pages.selection',
    },
  },
  publish: {
    pubRecord: {
      create: 'publish.pubRecord.create',
      del: 'publish.pubRecord.delete',
      info: 'publish.pubRecord.info',
      list: 'publish.pubRecord.list',
      updateStatus: 'publish.pubRecord.updateStatus',
    },
  },
  content: {
    material: {
      create: 'content.material.create',
      createTask: 'content.material.createTask',
      preview: 'content.material.preview',
      startTask: 'content.material.startTask',
      del: 'content.material.delete',
      updateInfo: 'content.material.updateInfo',
      info: 'content.material.info',
      list: 'content.material.list',
    },
    materialGroup: {
      createDefault: 'content.materialGroup.createDefault',
      create: 'content.materialGroup.create',
      del: 'content.materialGroup.delete',
      updateInfo: 'content.materialGroup.update',
      info: 'content.materialGroup.info',
      list: 'content.materialGroup.list',
    },
    media: {
      create: 'content.media.create',
      del: 'content.media.delete',
      info: 'content.media.info',
      list: 'content.media.list',
    },
    mediaGroup: {
      createDefault: 'content.mediaGroup.createDefault',
      create: 'content.mediaGroup.create',
      del: 'content.mediaGroup.delete',
      update: 'content.mediaGroup.update',
      info: 'content.mediaGroup.info',
      list: 'content.mediaGroup.list',
    },
  },
  other: {
    feedback: {
      create: 'other.feedback.create',
    },
    gologin: {
      doTest: 'other.gologin.doTest',
    },
  },
  payment: {
    list: 'payment.list',
    getById: 'payment.getById',
    create: 'payment.create',
    refund: 'payment.refund',
    subscription: 'payment.subscription',
    webhook: 'payment.webhook',
    unsubscribe: 'payment.unsubscribe',
  },
  task: {
    task: {
      info: 'task.task.info',
      rewardAmount: 'task.task.rewardAmount',
      accept: 'task.task.accept',
    },
    material: {
      create: 'task.material.create',
      regenerate: 'task.material.regenerate',
      get: 'task.material.get',
      listByTaskId: 'task.material.listByTaskId',
    },
    notification: {
      list: 'task.notification.list',
      detail: 'task.notification.detail',
      markRead: 'task.notification.markRead',
      markAllRead: 'task.notification.markAllRead',
      delete: 'task.notification.delete',
      unreadCount: 'task.notification.unreadCount',
    },
  },
  ai: {
    user: {
      chat: 'ai.user.chat',
      logs: 'ai.user.logs',
      imageGenerations: 'ai.user.image.generations',
      imageEdits: 'ai.user.image.edits',
      imageVariations: 'ai.user.image.variations',
      mjSubmitVideo: 'ai.user.mj.submit.video',
      mjTaskFetch: 'ai.user.mj.task.fetch',
      videoGenerations: 'ai.user.video.generations',
      videoTaskQuery: 'ai.user.video.task.query',
      md2card: 'ai.user.md2card.generate',
      fireflycard: 'ai.user.fireflycard.generate',
      imageGenerationModels: 'ai.user.image.generation.models',
      imageEditModels: 'ai.user.image.edit.models',
      videoGenerationModels: 'ai.user.video.generation.models',
    },
  },
}
