/*
 * Decompiled with CFR 0.152.
 */
package myjava.awt.datatransfer;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import myjava.awt.datatransfer.MimeTypeProcessor;
import myjava.awt.datatransfer.Transferable;
import myjava.awt.datatransfer.UnsupportedFlavorException;
import org.apache.harmony.awt.datatransfer.DTK;
import org.apache.harmony.awt.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlavor
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 8367026044764648243L;
    @Deprecated
    public static final DataFlavor plainTextFlavor = new DataFlavor("text/plain; charset=unicode; class=java.io.InputStream", "Plain Text");
    public static final DataFlavor stringFlavor = new DataFlavor("application/x-java-serialized-object; class=java.lang.String", "Unicode String");
    public static final DataFlavor javaFileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List", "application/x-java-file-list");
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    private static final String[] sortedTextFlavors = new String[]{"text/sgml", "text/xml", "text/html", "text/rtf", "text/enriched", "text/richtext", "text/uri-list", "text/tab-separated-values", "text/t140", "text/rfc822-headers", "text/parityfec", "text/directory", "text/css", "text/calendar", "application/x-java-serialized-object", "text/plain"};
    private static DataFlavor plainUnicodeFlavor = null;
    private String humanPresentableName;
    private Class<?> representationClass;
    private MimeTypeProcessor.MimeType mimeInfo;

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        if (plainUnicodeFlavor == null) {
            plainUnicodeFlavor = new DataFlavor("text/plain; charset=" + DTK.getDTK().getDefaultCharset() + "; class=java.io.InputStream", "Plain Text");
        }
        return plainUnicodeFlavor;
    }

    protected static final Class<?> tryToLoadClass(String className, ClassLoader fallback) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e0) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                if (contextLoader != null) {
                    try {
                        return contextLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return fallback.loadClass(className);
            }
        }
    }

    private static boolean isCharsetSupported(String charset) {
        try {
            return Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }

    public DataFlavor() {
        this.mimeInfo = null;
        this.humanPresentableName = null;
        this.representationClass = null;
    }

    public DataFlavor(Class<?> representationClass, String humanPresentableName) {
        this.mimeInfo = new MimeTypeProcessor.MimeType("application", "x-java-serialized-object");
        this.humanPresentableName = humanPresentableName != null ? humanPresentableName : javaSerializedObjectMimeType;
        this.mimeInfo.addParameter("class", representationClass.getName());
        this.representationClass = representationClass;
    }

    public DataFlavor(String mimeType, String humanPresentableName) {
        try {
            this.init(mimeType, humanPresentableName, null);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(Messages.getString("awt.16C", this.mimeInfo.getParameter("class")), e);
        }
    }

    public DataFlavor(String mimeType) throws ClassNotFoundException {
        this.init(mimeType, null, null);
    }

    public DataFlavor(String mimeType, String humanPresentableName, ClassLoader classLoader) throws ClassNotFoundException {
        this.init(mimeType, humanPresentableName, classLoader);
    }

    private void init(String mimeType, String humanPresentableName, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            this.mimeInfo = MimeTypeProcessor.parse(mimeType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Messages.getString("awt.16D", mimeType));
        }
        this.humanPresentableName = humanPresentableName != null ? humanPresentableName : String.valueOf(this.mimeInfo.getPrimaryType()) + '/' + this.mimeInfo.getSubType();
        String className = this.mimeInfo.getParameter("class");
        if (className == null) {
            className = "java.io.InputStream";
            this.mimeInfo.addParameter("class", className);
        }
        this.representationClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
    }

    private String getCharset() {
        if (this.mimeInfo == null || this.isCharsetRedundant()) {
            return "";
        }
        String charset = this.mimeInfo.getParameter("charset");
        if (this.isCharsetRequired() && (charset == null || charset.length() == 0)) {
            return DTK.getDTK().getDefaultCharset();
        }
        if (charset == null) {
            return "";
        }
        return charset;
    }

    private boolean isCharsetRequired() {
        String type = this.mimeInfo.getFullType();
        return type.equals("text/sgml") || type.equals("text/xml") || type.equals("text/html") || type.equals("text/enriched") || type.equals("text/richtext") || type.equals("text/uri-list") || type.equals("text/directory") || type.equals("text/css") || type.equals("text/calendar") || type.equals(javaSerializedObjectMimeType) || type.equals("text/plain");
    }

    private boolean isCharsetRedundant() {
        String type = this.mimeInfo.getFullType();
        return type.equals("text/rtf") || type.equals("text/tab-separated-values") || type.equals("text/t140") || type.equals("text/rfc822-headers") || type.equals("text/parityfec");
    }

    MimeTypeProcessor.MimeType getMimeInfo() {
        return this.mimeInfo;
    }

    public String getPrimaryType() {
        return this.mimeInfo != null ? this.mimeInfo.getPrimaryType() : null;
    }

    public String getSubType() {
        return this.mimeInfo != null ? this.mimeInfo.getSubType() : null;
    }

    public String getMimeType() {
        return this.mimeInfo != null ? MimeTypeProcessor.assemble(this.mimeInfo) : null;
    }

    public String getParameter(String paramName) {
        String lowerName = paramName.toLowerCase();
        if (lowerName.equals("humanpresentablename")) {
            return this.humanPresentableName;
        }
        return this.mimeInfo != null ? this.mimeInfo.getParameter(lowerName) : null;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public void setHumanPresentableName(String humanPresentableName) {
        this.humanPresentableName = humanPresentableName;
    }

    public Class<?> getRepresentationClass() {
        return this.representationClass;
    }

    public final Class<?> getDefaultRepresentationClass() {
        return InputStream.class;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public boolean isRepresentationClassSerializable() {
        return Serializable.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassRemote() {
        return false;
    }

    public boolean isRepresentationClassReader() {
        return Reader.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassInputStream() {
        return InputStream.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        return CharBuffer.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassByteBuffer() {
        return ByteBuffer.class.isAssignableFrom(this.representationClass);
    }

    @Deprecated
    protected String normalizeMimeTypeParameter(String parameterName, String parameterValue) {
        return parameterValue;
    }

    @Deprecated
    protected String normalizeMimeType(String mimeType) {
        return mimeType;
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.mimeInfo != null ? this.mimeInfo.equals(dataFlavor.mimeInfo) : dataFlavor.mimeInfo == null;
    }

    public boolean isMimeTypeEqual(String mimeType) {
        try {
            return this.mimeInfo.equals(MimeTypeProcessor.parse(mimeType));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public synchronized void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(this.humanPresentableName);
        os.writeObject(this.mimeInfo);
    }

    @Override
    public synchronized void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        this.humanPresentableName = (String)is.readObject();
        this.mimeInfo = (MimeTypeProcessor.MimeType)is.readObject();
        this.representationClass = this.mimeInfo != null ? Class.forName(this.mimeInfo.getParameter("class")) : null;
    }

    public Object clone() throws CloneNotSupportedException {
        DataFlavor clone = new DataFlavor();
        clone.humanPresentableName = this.humanPresentableName;
        clone.representationClass = this.representationClass;
        clone.mimeInfo = this.mimeInfo != null ? (MimeTypeProcessor.MimeType)this.mimeInfo.clone() : null;
        return clone;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[MimeType=(" + this.getMimeType() + ");humanPresentableName=" + this.humanPresentableName + "]";
    }

    public boolean isMimeTypeSerializedObject() {
        return this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)o);
    }

    public boolean equals(DataFlavor that) {
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.mimeInfo == null) {
            return that.mimeInfo == null;
        }
        if (!this.mimeInfo.equals(that.mimeInfo) || !this.representationClass.equals(that.representationClass)) {
            return false;
        }
        if (!this.mimeInfo.getPrimaryType().equals("text") || this.isUnicodeFlavor()) {
            return true;
        }
        String charset1 = this.getCharset();
        String charset2 = that.getCharset();
        if (!DataFlavor.isCharsetSupported(charset1) || !DataFlavor.isCharsetSupported(charset2)) {
            return charset1.equalsIgnoreCase(charset2);
        }
        return Charset.forName(charset1).equals(Charset.forName(charset2));
    }

    @Deprecated
    public boolean equals(String s) {
        if (s == null) {
            return false;
        }
        return this.isMimeTypeEqual(s);
    }

    public boolean match(DataFlavor that) {
        return this.equals(that);
    }

    public int hashCode() {
        return this.getKeyInfo().hashCode();
    }

    private String getKeyInfo() {
        String key = String.valueOf(this.mimeInfo.getFullType()) + ";class=" + this.representationClass.getName();
        if (!this.mimeInfo.getPrimaryType().equals("text") || this.isUnicodeFlavor()) {
            return key;
        }
        return String.valueOf(key) + ";charset=" + this.getCharset().toLowerCase();
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isMimeTypeSerializedObject() && this.isRepresentationClassSerializable();
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isMimeTypeEqual(javaRemoteObjectMimeType) && this.isRepresentationClassRemote();
    }

    public boolean isFlavorJavaFileListType() {
        return List.class.isAssignableFrom(this.representationClass) && this.isMimeTypeEqual(javaFileListFlavor);
    }

    public boolean isFlavorTextType() {
        if (this.equals(stringFlavor) || this.equals(plainTextFlavor)) {
            return true;
        }
        if (this.mimeInfo != null && !this.mimeInfo.getPrimaryType().equals("text")) {
            return false;
        }
        String charset = this.getCharset();
        if (this.isByteCodeFlavor()) {
            if (charset.length() != 0) {
                return DataFlavor.isCharsetSupported(charset);
            }
            return true;
        }
        return this.isUnicodeFlavor();
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        InputStream stream;
        Object data = transferable.getTransferData(this);
        if (data == null) {
            throw new IllegalArgumentException(Messages.getString("awt.16E"));
        }
        if (data instanceof Reader) {
            Reader reader = (Reader)data;
            reader.reset();
            return reader;
        }
        if (data instanceof String) {
            return new StringReader((String)data);
        }
        if (data instanceof CharBuffer) {
            return new CharArrayReader(((CharBuffer)data).array());
        }
        if (data instanceof char[]) {
            return new CharArrayReader((char[])data);
        }
        String charset = this.getCharset();
        if (data instanceof InputStream) {
            stream = (InputStream)data;
            stream.reset();
        } else if (data instanceof ByteBuffer) {
            stream = new ByteArrayInputStream(((ByteBuffer)data).array());
        } else if (data instanceof byte[]) {
            stream = new ByteArrayInputStream((byte[])data);
        } else {
            throw new IllegalArgumentException(Messages.getString("awt.16F"));
        }
        if (charset.length() == 0) {
            return new InputStreamReader(stream);
        }
        return new InputStreamReader(stream, charset);
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] availableFlavors) {
        if (availableFlavors == null) {
            return null;
        }
        List<List<DataFlavor>> sorted = DataFlavor.sortTextFlavorsByType(new LinkedList<DataFlavor>(Arrays.asList(availableFlavors)));
        if (sorted.isEmpty()) {
            return null;
        }
        List<DataFlavor> bestSorted = sorted.get(0);
        if (bestSorted.size() == 1) {
            return bestSorted.get(0);
        }
        if (bestSorted.get(0).getCharset().length() == 0) {
            return DataFlavor.selectBestFlavorWOCharset(bestSorted);
        }
        return DataFlavor.selectBestFlavorWCharset(bestSorted);
    }

    private static DataFlavor selectBestFlavorWCharset(List<DataFlavor> list) {
        List<DataFlavor> best = DataFlavor.getFlavors(list, Reader.class);
        if (best != null) {
            return best.get(0);
        }
        best = DataFlavor.getFlavors(list, String.class);
        if (best != null) {
            return best.get(0);
        }
        best = DataFlavor.getFlavors(list, CharBuffer.class);
        if (best != null) {
            return best.get(0);
        }
        best = DataFlavor.getFlavors(list, char[].class);
        if (best != null) {
            return best.get(0);
        }
        return DataFlavor.selectBestByCharset(list);
    }

    private static DataFlavor selectBestByCharset(List<DataFlavor> list) {
        List<DataFlavor> best = DataFlavor.getFlavors(list, new String[]{"UTF-16", "UTF-8", "UTF-16BE", "UTF-16LE"});
        if (best == null && (best = DataFlavor.getFlavors(list, new String[]{DTK.getDTK().getDefaultCharset()})) == null && (best = DataFlavor.getFlavors(list, new String[]{"US-ASCII"})) == null) {
            best = DataFlavor.selectBestByAlphabet(list);
        }
        if (best != null) {
            if (best.size() == 1) {
                return best.get(0);
            }
            return DataFlavor.selectBestFlavorWOCharset(best);
        }
        return null;
    }

    private static List<DataFlavor> selectBestByAlphabet(List<DataFlavor> list) {
        String[] charsets = new String[list.size()];
        LinkedList<DataFlavor> best = new LinkedList<DataFlavor>();
        int i = 0;
        while (i < charsets.length) {
            charsets[i] = list.get(i).getCharset();
            ++i;
        }
        Arrays.sort(charsets, String.CASE_INSENSITIVE_ORDER);
        for (DataFlavor flavor : list) {
            if (!charsets[0].equalsIgnoreCase(flavor.getCharset())) continue;
            best.add(flavor);
        }
        return best.isEmpty() ? null : best;
    }

    private static List<DataFlavor> getFlavors(List<DataFlavor> list, String[] charset) {
        LinkedList<DataFlavor> sublist = new LinkedList<DataFlavor>();
        Iterator<DataFlavor> i = list.iterator();
        while (i.hasNext()) {
            DataFlavor flavor = i.next();
            if (DataFlavor.isCharsetSupported(flavor.getCharset())) {
                String[] stringArray = charset;
                int n = charset.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    if (Charset.forName(element).equals(Charset.forName(flavor.getCharset()))) {
                        sublist.add(flavor);
                    }
                    ++n2;
                }
                continue;
            }
            i.remove();
        }
        return sublist.isEmpty() ? null : list;
    }

    private static DataFlavor selectBestFlavorWOCharset(List<DataFlavor> list) {
        List<DataFlavor> best = DataFlavor.getFlavors(list, InputStream.class);
        if (best != null) {
            return best.get(0);
        }
        best = DataFlavor.getFlavors(list, ByteBuffer.class);
        if (best != null) {
            return best.get(0);
        }
        best = DataFlavor.getFlavors(list, byte[].class);
        if (best != null) {
            return best.get(0);
        }
        return list.get(0);
    }

    private static List<DataFlavor> getFlavors(List<DataFlavor> list, Class<?> klass) {
        LinkedList<DataFlavor> sublist = new LinkedList<DataFlavor>();
        for (DataFlavor flavor : list) {
            if (!flavor.representationClass.equals(klass)) continue;
            sublist.add(flavor);
        }
        return sublist.isEmpty() ? null : list;
    }

    private static List<List<DataFlavor>> sortTextFlavorsByType(List<DataFlavor> availableFlavors) {
        LinkedList<List<DataFlavor>> list = new LinkedList<List<DataFlavor>>();
        String[] stringArray = sortedTextFlavors;
        int n = sortedTextFlavors.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            List<DataFlavor> subList = DataFlavor.fetchTextFlavors(availableFlavors, element);
            if (subList != null) {
                list.addLast(subList);
            }
            ++n2;
        }
        if (!availableFlavors.isEmpty()) {
            list.addLast(availableFlavors);
        }
        return list;
    }

    private static List<DataFlavor> fetchTextFlavors(List<DataFlavor> availableFlavors, String mimeType) {
        LinkedList<DataFlavor> list = new LinkedList<DataFlavor>();
        Iterator<DataFlavor> i = availableFlavors.iterator();
        while (i.hasNext()) {
            DataFlavor flavor = i.next();
            if (flavor.isFlavorTextType()) {
                if (!flavor.mimeInfo.getFullType().equals(mimeType)) continue;
                if (!list.contains(flavor)) {
                    list.add(flavor);
                }
                i.remove();
                continue;
            }
            i.remove();
        }
        return list.isEmpty() ? null : list;
    }

    private boolean isUnicodeFlavor() {
        return this.representationClass != null && (this.representationClass.equals(Reader.class) || this.representationClass.equals(String.class) || this.representationClass.equals(CharBuffer.class) || this.representationClass.equals(char[].class));
    }

    private boolean isByteCodeFlavor() {
        return this.representationClass != null && (this.representationClass.equals(InputStream.class) || this.representationClass.equals(ByteBuffer.class) || this.representationClass.equals(byte[].class));
    }
}

