# Apache Kafka

## Reading Records from Kafka

Quine has full support for reading records from Apache Kafka topics. The means by which Quine interprets records into graph data is configurable via @ref:[REST API](../../reference/rest-api.md) and @ref:[Recipes](../../core-concepts/about-recipes.md).

### Example

In this example we will ingest messages from a Kafka topic as nodes in the graph.

#### Preparation

For this example we will run Kafka locally. Because Kafka depends on ZooKeeper, we will start that too. [Download Kafka](https://kafka.apache.org/downloads), and extract the files to your local filesystem. Start each of ZooKeeper and Kafka in separate terminal sessions by running each of the following commands from the directory where you extracted Kafka.

```
bin/zookeeper-server-start.sh config/zookeeper.properties
```

```
bin/kafka-server-start.sh config/server.properties
```

With Kafka up and running, messages can be manually sent to the topic using the following command:

```
bin/kafka-console-producer.sh --bootstrap-server localhost:9092 --topic test-topic
>{"Message": "Hello, world."}
>^D
```

While `kafka-console-producer.sh` is running, messages are generated by inputting text followed by a new line. To end the program and stop generating messages, use Control-D.

#### Using a Recipe

The following is a simple Recipe that ingests each message from the Kafka topic as a node in the graph:

@@snip [template-recipe.yaml]($quine$/recipes/kafka-ingest.yaml)

To run this Recipe, run Quine as follows:

```
java -jar quine.jar -r kafka-ingest
Graph is ready!
Application state loaded.
Running Recipe Kafka Ingest
Running Ingest Stream INGEST-1
Quine app web server available at http://0.0.0.0:8080

 | => INGEST-1 status is running and ingested 0
```

Quine has downloaded the Recipe and begun execution. As shown above, use `kafka-console-producer.sh` to send a JSON record to the stream. Quine should immediately report that it has ingested the record.

```
| => INGEST-1 status is running and ingested 1
```

Results should already be available in the web UI at [localhost:8080](localhost:8080]).
