/*
 * Copyright (c) 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

/*
 * @test
 * @summary Test interaction with JIT threads during vm exit.
 * @requires vm.cds
 * @library /test/lib /test/hotspot/jtreg/runtime/cds/appcds /test/hotspot/jtreg/runtime/cds/appcds/dynamicArchive/test-classes
 * @build TestJIT
 * @build sun.hotspot.WhiteBox
 * @run driver ClassFileInstaller -jar WhiteBox.jar sun.hotspot.WhiteBox
 * @run driver ClassFileInstaller -jar testjit.jar TestJIT
 * @run driver JITInteraction
 */

public class JITInteraction extends DynamicArchiveTestBase {

    public static void main(String[] args) throws Exception {
        runTest(JITInteraction::testDefaultBase);
    }

    // Test with default base archive + top archive
    static void testDefaultBase() throws Exception {
        String topArchiveName = getNewArchiveName("top");
        doTest(topArchiveName);
    }

    private static void doTest(String topArchiveName) throws Exception {
        String appJar = ClassFileInstaller.getJarPath("testjit.jar");
        String mainClass = "TestJIT";

        dump2_WB(null, topArchiveName,
                 "-Xlog:cds",
                 "-Xlog:cds+dynamic",
                 "-XX:-UseOnStackReplacement",
                 "-XX:+PrintCompilation",
                 "-cp", appJar, mainClass)
                .assertNormalExit(output -> {
                    output.shouldContain("Buffer-space to target-space delta")
                           .shouldContain("Written dynamic archive 0x");
                });
    }
}
