/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.base;
public class StringsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.base.testModule";
}
public void testCommonPrefix() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testCommonPrefix();
}

public void testCommonSuffix() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testCommonSuffix();
}

public void testEmptyToNull() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testEmptyToNull();
}

public void testIsNullOrEmpty() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testIsNullOrEmpty();
}

public void testLenientFormat() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testLenientFormat();
}

public void testNullToEmpty() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testNullToEmpty();
}

public void testPadEnd_negativeMinLength() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadEnd_negativeMinLength();
}

public void testPadEnd_noPadding() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadEnd_noPadding();
}

public void testPadEnd_null() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadEnd_null();
}

public void testPadEnd_somePadding() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadEnd_somePadding();
}

public void testPadStart_negativeMinLength() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadStart_negativeMinLength();
}

public void testPadStart_noPadding() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadStart_noPadding();
}

public void testPadStart_null() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadStart_null();
}

public void testPadStart_somePadding() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testPadStart_somePadding();
}

public void testRepeat() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testRepeat();
}

public void testRepeat_null() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testRepeat_null();
}

public void testValidSurrogatePairAt() throws Exception {
  com.google.common.base.StringsTest testCase = new com.google.common.base.StringsTest();
  testCase.testValidSurrogatePairAt();
}
}
