/*
 * g722_1 - a library for the G.722.1 and Annex C codecs
 *
 * dct4_s.h
 *
 * Adapted by Steve Underwood <steveu@coppice.org> from the reference
 * code supplied with ITU G.722.1, which is:
 *
 *   (C) 2004 Polycom, Inc.
 *   All rights reserved.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

typedef struct
{
    int16_t cosine;
    int16_t minus_sine;
} cos_msin_t;

/***************************************************************************
  The dct_core_s table was generated by the following code

      for (i = 0;  i < 10;  ++i)
      {
          for (k = 0;  k < 10; ++k)
          {
              dct_core_s[i][k] = (short) (FTOI(((.9*32768.)*cos(3.1415926*(k+0.5)*(i+0.5)/10.))));
          }
      }
***************************************************************************/
static const int16_t dct_core_s[10][10] =
{
    { 29400,   28676,   27246,   25145,   22425,   19153,   15409,   11286,    6885,    2314},
    { 28676,   22425,   11286,   -2314,  -15409,  -25145,  -29400,  -27246,  -19153,   -6885},
    { 27246,   11286,  -11286,  -27246,  -27246,  -11286,   11286,   27246,   27246,   11286},
    { 25145,   -2314,  -27246,  -22425,    6885,   28676,   19153,  -11286,  -29400,  -15409},
    { 22425,  -15409,  -27246,    6885,   29400,    2314,  -28676,  -11286,   25145,   19153},
    { 19153,  -25145,  -11286,   28676,    2314,  -29400,    6885,   27246,  -15409,  -22425},
    { 15409,  -29400,   11286,   19153,  -28676,    6885,   22425,  -27246,    2314,   25145},
    { 11286,  -27246,   27246,  -11286,  -11286,   27246,  -27246,   11286,   11286,  -27246},
    {  6885,  -19153,   27246,  -29400,   25145,  -15409,    2314,   11286,  -22425,   28676},
    {  2314,   -6885,   11286,  -15409,   19153,  -22425,   25145,  -27246,   28676,  -29400}
};

static const int16_t syn_bias_7khz[DCT_LENGTH] =
{
    -4,  4, -5, -2,  0, -4,  6,  2, -2, -4,
    -3,  3,  0,  0, -2,  4,  0,  0,  3, -6,
     8,  5,  4,  5, -8,  0, -2,  0,  0, -3,
     3,  0,  0,  0,  1, -1, -2,  0,  0,  2,
    -2, -5, -2,  3,  2, -1, -1, -6,  3,  1,
    -7,  4,  4,  0,  1,  4,  1,  0,  1, -5,
    -1,  1, -6,  0, -1, -1,  3,  0, -2,  1,
     2, -4,  0,  9,  0, -3,  1,  1,  1,  0,
    -3, -2, -1, -4, -2,  0,  5,  2, -3,  5,
     0, -2,  4,  4,  0, -6, -4,  2,  0,  0,
     0, -1, -1, -2,  0,  6,  1,  0,  0, -1,
     0, -4, -1,  0, -4,  1, -1, -5,  0,  1,
     2,  4,  0, -8, -4,  0, -2, -2,  2,  5,
    -3, -1,  1, -4,  0,  0,  0, -1, -3,  0,
    -5, -4,  0, -2,  0,  7,  1,  0,  5, -2,
    -1,  2,  2, -2,  3,  7, -3,  4,  1, -4,
     0,  0,  3, -7, -5,  0,  0,  4,  0, -2,
    -1,  0, -5,  0,  2,  0, 11,  5, -1,  0,
     2,  2, -2, -2,  5,  4, -3,  1,  0, -2,
     1,  3,  2,  0,  1,  0,  0,  0,  5,  6,
    -2, -1,  0,  2,  3,  2,  0, -3,  4,  5,
     0, -1,  0,  3,  1, -2, -3, -2, -1,  2,
    -1, -1, -2, -7,  4,  6, -5, -6, -3, -4,
     0,  2, -5, -2,  3,  0,  0,  0,  2, -2,
    -4,  3,  3,  1,  0,  0,  4, -1,  8, 13,
     1,  2,  0,  2,  0, -1,  4, -3,  1,  0,
    -1,  3,  0,  0, -5,  0,  6,  2,  4,  5,
     2, -1, -1,  3,  6,  1,  1,  2, -4,  0,
    -1, -6, -2, -2,  2,  1,  2,  6,  2,  0,
    -2, -2,  0, -1,  2,  0,  0,  3, -2,  1,
     3,  1,  2, -1, -2,  2,  2, -4,  0,  0,
    -3,  0, -4, -3,  6,  7,  2,  2,  0, -3
};

static const int16_t dither[DCT_LENGTH] =
{
     1,  0,  0,  0,  1,  0,  0,  1,  1,  1,
     1,  0,  0,  0,  1,  1,  1,  1,  1,  0,
     0,  1,  1,  1,  0,  1,  1,  0,  0,  0,
     1,  0,  0,  1,  0,  1,  0,  0,  1,  0,
     1,  0,  0,  0,  1,  0,  1,  0,  0,  0,
     1,  1,  1,  1,  1,  0,  0,  1,  0,  0,
     0,  0,  1,  0,  0,  0,  1,  0,  0,  1,
     1,  1,  1,  1,  1,  0,  1,  0,  0,  1,
     1,  0,  0,  1,  0,  0,  0,  1,  0,  1,
     0,  0,  1,  1,  0,  1,  0,  1,  1,  1,
     1,  0,  0,  0,  0,  1,  1,  1,  1,  1,
     0,  0,  0,  1,  0,  1,  0,  0,  0,  1,
     1,  1,  0,  0,  1,  1,  1,  1,  1,  0,
     0,  1,  1,  1,  1,  0,  1,  1,  1,  0,
     1,  1,  1,  0,  0,  0,  0,  0,  0,  0,
     1,  0,  1,  1,  1,  1,  0,  0,  0,  0,
     1,  1,  0,  1,  0,  0,  1,  0,  0,  1,
     0,  0,  0,  1,  1,  0,  0,  1,  1,  1,
     1,  0,  0,  0,  0,  0,  1,  1,  1,  1,
     1,  0,  0,  1,  1,  0,  1,  1,  0,  0,
     1,  1,  1,  0,  1,  1,  0,  1,  0,  1,
     0,  0,  1,  1,  1,  1,  1,  1,  0,  1,
     0,  1,  1,  1,  1,  0,  1,  1,  1,  0,
     1,  1,  1,  0,  1,  1,  1,  0,  1,  0,
     1,  1,  0,  0,  1,  0,  0,  1,  0,  1,
     0,  1,  1,  0,  1,  0,  1,  0,  1,  1,
     1,  0,  1,  0,  1,  0,  1,  1,  1,  1,
     0,  1,  0,  0,  0,  1,  0,  0,  0,  1,
     1,  0,  0,  0,  1,  0,  0,  1,  0,  1,
     1,  0,  1,  1,  0,  0,  1,  1,  0,  1,
     1,  0,  1,  1,  1,  1,  1,  1,  0,  1,
     1,  1,  1,  0,  1,  0,  0,  0,  1,  0
};

static const int16_t max_dither[MAX_DCT_LENGTH] =
{
     1,  0,  1,  0,  1,  1,  0,  1,  0,  1,
     1,  1,  0,  0,  0,  0,  0,  1,  1,  1,
     1,  1,  1,  0,  1,  1,  0,  0,  0,  1,
     0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
     1,  1,  1,  0,  1,  0,  1,  1,  1,  1,
     0,  1,  0,  1,  1,  1,  1,  1,  1,  0,
     1,  0,  1,  1,  0,  1,  0,  0,  0,  1,
     0,  1,  1,  1,  1,  1,  0,  1,  1,  0,
     0,  0,  1,  1,  0,  0,  0,  1,  1,  1,
     1,  0,  1,  1,  1,  1,  1,  0,  0,  0,
     1,  0,  1,  0,  1,  0,  0,  0,  1,  1,
     0,  1,  1,  1,  1,  1,  1,  0,  1,  0,
     0,  0,  1,  0,  1,  0,  0,  0,  1,  0,
     0,  1,  0,  1,  0,  0,  0,  0,  1,  0,
     1,  0,  0,  1,  0,  1,  0,  0,  0,  1,
     0,  1,  0,  0,  1,  1,  1,  1,  0,  1,
     1,  0,  0,  0,  1,  1,  0,  1,  0,  1,
     0,  1,  0,  1,  0,  1,  1,  1,  0,  1,
     1,  0,  0,  1,  1,  1,  1,  0,  1,  1,
     1,  1,  1,  0,  1,  1,  0,  0,  0,  0,
     1,  0,  1,  0,  0,  0,  0,  1,  1,  0,
     1,  1,  0,  0,  0,  0,  1,  0,  0,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  0,
     0,  0,  1,  1,  1,  0,  1,  1,  1,  0,
     0,  1,  1,  1,  1,  1,  1,  1,  0,  0,
     1,  1,  1,  1,  1,  1,  0,  1,  1,  1,
     0,  0,  1,  1,  0,  1,  0,  1,  0,  1,
     0,  0,  1,  1,  1,  1,  1,  1,  0,  1,
     0,  1,  1,  1,  0,  1,  0,  1,  0,  0,
     0,  1,  0,  1,  1,  0,  0,  0,  1,  0,
     1,  1,  0,  0,  1,  1,  1,  1,  0,  0,
     0,  0,  1,  1,  1,  1,  0,  0,  1,  1,
     1,  1,  1,  0,  1,  0,  0,  0,  1,  0,
     0,  1,  1,  1,  0,  1,  0,  1,  0,  0,
     1,  1,  0,  1,  0,  1,  1,  0,  0,  0,
     0,  1,  1,  0,  1,  1,  1,  0,  1,  1,
     0,  0,  1,  1,  1,  1,  1,  1,  0,  1,
     1,  1,  0,  0,  0,  1,  1,  1,  1,  0,
     0,  1,  0,  1,  0,  1,  1,  0,  1,  0,
     1,  1,  1,  0,  0,  1,  1,  0,  0,  1,
     0,  1,  0,  0,  0,  1,  1,  0,  0,  1,
     0,  0,  1,  1,  0,  1,  0,  1,  0,  1,
     1,  1,  0,  1,  0,  0,  1,  1,  0,  0,
     1,  0,  1,  0,  1,  0,  0,  1,  0,  0,
     0,  1,  0,  1,  1,  1,  1,  1,  1,  0,
     0,  1,  1,  0,  0,  0,  1,  1,  1,  0,
     1,  1,  1,  0,  1,  1,  1,  0,  0,  0,
     0,  0,  1,  0,  0,  1,  0,  0,  0,  1,
     0,  0,  0,  1,  1,  0,  0,  1,  0,  1,
     1,  1,  1,  1,  0,  0,  1,  0,  1,  0,
     0,  1,  0,  1,  1,  1,  1,  1,  1,  0,
     0,  0,  1,  0,  1,  0,  0,  1,  0,  1,
     1,  0,  1,  0,  1,  1,  0,  0,  1,  1,
     1,  1,  1,  0,  1,  0,  0,  1,  1,  1,
     0,  1,  0,  1,  0,  1,  0,  0,  0,  1,
     1,  0,  0,  1,  0,  0,  1,  1,  0,  1,
     1,  0,  1,  0,  1,  1,  0,  0,  1,  1,
     0,  0,  0,  1,  0,  1,  1,  1,  0,  0,
     1,  0,  1,  0,  1,  1,  0,  0,  0,  1,
     1,  0,  1,  0,  0,  1,  1,  1,  0,  1,
     0,  0,  1,  1,  1,  1,  1,  0,  0,  0,
     0,  1,  0,  1,  0,  0,  1,  0,  1,  0,
     0,  1,  1,  1,  1,  0,  0,  0,  1,  0,
     0,  1,  0,  1,  0,  1,  0,  0,  0,  0
};


/********************************************************************************
  The s_cos_min tables were generated by the following code:
      double  angle, scale;
      int      index;

      for (index = 0;index < length;index++)
      {
          angle = scale * ((double)index + 0.5);
          table[index].cosine = (int16_t) (FTOI((18427)* cos(angle)));
          table[index].minus_sine = (int16_t) (FTOI((18427)*(-sin(angle))));
      }
********************************************************************************/

static const cos_msin_t s_cos_msin_2[DCT_LENGTH_DIV_32] =
{
    {18413,   -723},
    {18299,  -2166},
    {18073,  -3595},
    {17735,  -5002},
    {17288,  -6378},
    {16734,  -7715},
    {16077,  -9004},
    {15321, -10237},
    {14471, -11408},
    {13531, -12508}
};

static const cos_msin_t s_cos_msin_4[DCT_LENGTH_DIV_16] =
{
    {18423,   -362},
    {18395,  -1085},
    {18338,  -1806},
    {18253,  -2525},
    {18140,  -3239},
    {17999,  -3949},
    {17830,  -4653},
    {17634,  -5349},
    {17410,  -6037},
    {17159,  -6716},
    {16883,  -7385},
    {16580,  -8042},
    {16251,  -8686},
    {15898,  -9318},
    {15520,  -9935},
    {15118, -10536},
    {14692, -11122},
    {14244, -11690},
    {13774, -12240},
    {13283, -12772}
};

static const cos_msin_t s_cos_msin_8[DCT_LENGTH_DIV_8] =
{
    {18426,   -181},
    {18419,   -543},
    {18405,   -904},
    {18384,  -1265},
    {18355,  -1626},
    {18320,  -1986},
    {18277,  -2345},
    {18228,  -2704},
    {18171,  -3061},
    {18107,  -3417},
    {18037,  -3772},
    {17959,  -4126},
    {17875,  -4477},
    {17783,  -4827},
    {17685,  -5176},
    {17580,  -5522},
    {17468,  -5866},
    {17350,  -6208},
    {17225,  -6547},
    {17093,  -6884},
    {16954,  -7219},
    {16809,  -7550},
    {16658,  -7879},
    {16500,  -8204},
    {16336,  -8526},
    {16165,  -8846},
    {15988,  -9161},
    {15805,  -9473},
    {15616,  -9782},
    {15421, -10087},
    {15220, -10387},
    {15013, -10684},
    {14801, -10977},
    {14582, -11265},
    {14358, -11550},
    {14129, -11829},
    {13894, -12104},
    {13654, -12375},
    {13408, -12641},
    {13157, -12901}
};

static const cos_msin_t s_cos_msin_16[DCT_LENGTH_DIV_4] =
{
    {18427,    -90},
    {18425,   -271},
    {18421,   -452},
    {18416,   -633},
    {18409,   -814},
    {18400,   -995},
    {18389,  -1175},
    {18377,  -1356},
    {18363,  -1536},
    {18347,  -1716},
    {18329,  -1896},
    {18310,  -2076},
    {18288,  -2256},
    {18265,  -2435},
    {18241,  -2614},
    {18214,  -2793},
    {18186,  -2972},
    {18156,  -3150},
    {18124,  -3328},
    {18090,  -3506},
    {18055,  -3684},
    {18018,  -3861},
    {17979,  -4037},
    {17939,  -4214},
    {17897,  -4390},
    {17853,  -4565},
    {17807,  -4740},
    {17760,  -4915},
    {17710,  -5089},
    {17660,  -5262},
    {17607,  -5436},
    {17553,  -5608},
    {17497,  -5780},
    {17439,  -5952},
    {17380,  -6123},
    {17319,  -6293},
    {17257,  -6463},
    {17192,  -6632},
    {17126,  -6800},
    {17059,  -6968},
    {16990,  -7135},
    {16919,  -7302},
    {16846,  -7467},
    {16772,  -7632},
    {16696,  -7797},
    {16619,  -7960},
    {16540,  -8123},
    {16459,  -8285},
    {16377,  -8446},
    {16294,  -8607},
    {16208,  -8766},
    {16121,  -8925},
    {16033,  -9083},
    {15943,  -9240},
    {15852,  -9396},
    {15759,  -9551},
    {15664,  -9705},
    {15568,  -9858},
    {15471, -10011},
    {15372, -10162},
    {15271, -10313},
    {15169, -10462},
    {15066, -10610},
    {14961, -10758},
    {14854, -10904},
    {14747, -11049},
    {14637, -11194},
    {14527, -11337},
    {14415, -11479},
    {14301, -11620},
    {14187, -11760},
    {14071, -11898},
    {13953, -12036},
    {13834, -12172},
    {13714, -12308},
    {13593, -12442},
    {13470, -12575},
    {13346, -12706},
    {13220, -12837},
    {13094, -12966}
};

static const cos_msin_t s_cos_msin_32[DCT_LENGTH_DIV_2] =
{
    {18427,    -45},
    {18427,   -136},
    {18426,   -226},
    {18424,   -317},
    {18423,   -407},
    {18420,   -497},
    {18418,   -588},
    {18415,   -678},
    {18411,   -769},
    {18407,   -859},
    {18403,   -949},
    {18398,  -1040},
    {18392,  -1130},
    {18387,  -1220},
    {18380,  -1310},
    {18374,  -1401},
    {18367,  -1491},
    {18359,  -1581},
    {18351,  -1671},
    {18343,  -1761},
    {18334,  -1851},
    {18324,  -1941},
    {18315,  -2031},
    {18305,  -2121},
    {18294,  -2211},
    {18283,  -2301},
    {18271,  -2390},
    {18259,  -2480},
    {18247,  -2570},
    {18234,  -2659},
    {18221,  -2749},
    {18207,  -2838},
    {18193,  -2927},
    {18178,  -3017},
    {18163,  -3106},
    {18148,  -3195},
    {18132,  -3284},
    {18116,  -3373},
    {18099,  -3462},
    {18082,  -3551},
    {18064,  -3639},
    {18046,  -3728},
    {18027,  -3816},
    {18009,  -3905},
    {17989,  -3993},
    {17969,  -4081},
    {17949,  -4170},
    {17928,  -4258},
    {17907,  -4346},
    {17886,  -4434},
    {17864,  -4521},
    {17841,  -4609},
    {17818,  -4696},
    {17795,  -4784},
    {17772,  -4871},
    {17747,  -4958},
    {17723,  -5045},
    {17698,  -5132},
    {17672,  -5219},
    {17647,  -5306},
    {17620,  -5392},
    {17594,  -5479},
    {17567,  -5565},
    {17539,  -5651},
    {17511,  -5737},
    {17483,  -5823},
    {17454,  -5909},
    {17425,  -5994},
    {17395,  -6080},
    {17365,  -6165},
    {17335,  -6250},
    {17304,  -6335},
    {17272,  -6420},
    {17241,  -6505},
    {17208,  -6590},
    {17176,  -6674},
    {17143,  -6758},
    {17110,  -6842},
    {17076,  -6926},
    {17042,  -7010},
    {17007,  -7093},
    {16972,  -7177},
    {16937,  -7260},
    {16901,  -7343},
    {16864,  -7426},
    {16828,  -7509},
    {16791,  -7591},
    {16753,  -7674},
    {16715,  -7756},
    {16677,  -7838},
    {16638,  -7919},
    {16599,  -8001},
    {16560,  -8082},
    {16520,  -8164},
    {16480,  -8245},
    {16439,  -8325},
    {16398,  -8406},
    {16357,  -8486},
    {16315,  -8567},
    {16272,  -8647},
    {16230,  -8726},
    {16187,  -8806},
    {16143,  -8885},
    {16100,  -8964},
    {16055,  -9043},
    {16011,  -9122},
    {15966,  -9200},
    {15920,  -9279},
    {15875,  -9357},
    {15829,  -9435},
    {15782,  -9512},
    {15735,  -9589},
    {15688,  -9667},
    {15640,  -9744},
    {15592,  -9820},
    {15544,  -9897},
    {15495,  -9973},
    {15446, -10049},
    {15396, -10124},
    {15347, -10200},
    {15296, -10275},
    {15246, -10350},
    {15195, -10425},
    {15143, -10499},
    {15092, -10573},
    {15040, -10647},
    {14987, -10721},
    {14934, -10794},
    {14881, -10868},
    {14828, -10941},
    {14774, -11013},
    {14719, -11086},
    {14665, -11158},
    {14610, -11230},
    {14555, -11301},
    {14499, -11372},
    {14443, -11444},
    {14387, -11514},
    {14330, -11585},
    {14273, -11655},
    {14216, -11725},
    {14158, -11795},
    {14100, -11864},
    {14041, -11933},
    {13983, -12002},
    {13924, -12070},
    {13864, -12138},
    {13804, -12206},
    {13744, -12274},
    {13684, -12341},
    {13623, -12408},
    {13562, -12475},
    {13501, -12541},
    {13439, -12608},
    {13377, -12673},
    {13314, -12739},
    {13252, -12804},
    {13189, -12869},
    {13125, -12934},
    {13062, -12998}
};

static const cos_msin_t s_cos_msin_64[DCT_LENGTH] =
{
    {18426,    -21},
    {18426,    -66},
    {18426,   -110},
    {18426,   -154},
    {18425,   -198},
    {18425,   -242},
    {18424,   -286},
    {18424,   -331},
    {18423,   -374},
    {18421,   -419},
    {18421,   -463},
    {18419,   -507},
    {18418,   -552},
    {18417,   -595},
    {18415,   -639},
    {18414,   -684},
    {18412,   -728},
    {18410,   -772},
    {18408,   -816},
    {18406,   -860},
    {18404,   -904},
    {18402,   -949},
    {18400,   -992},
    {18397,  -1037},
    {18394,  -1081},
    {18392,  -1125},
    {18389,  -1169},
    {18387,  -1213},
    {18384,  -1257},
    {18380,  -1301},
    {18378,  -1345},
    {18374,  -1389},
    {18371,  -1433},
    {18367,  -1477},
    {18364,  -1521},
    {18360,  -1566},
    {18356,  -1609},
    {18352,  -1653},
    {18348,  -1697},
    {18344,  -1742},
    {18339,  -1785},
    {18335,  -1829},
    {18331,  -1873},
    {18326,  -1917},
    {18322,  -1961},
    {18317,  -2005},
    {18312,  -2049},
    {18307,  -2092},
    {18302,  -2137},
    {18297,  -2180},
    {18292,  -2224},
    {18286,  -2268},
    {18281,  -2312},
    {18275,  -2356},
    {18270,  -2399},
    {18264,  -2443},
    {18258,  -2487},
    {18252,  -2531},
    {18246,  -2574},
    {18240,  -2618},
    {18233,  -2662},
    {18227,  -2706},
    {18220,  -2749},
    {18214,  -2793},
    {18207,  -2836},
    {18200,  -2880},
    {18193,  -2924},
    {18186,  -2967},
    {18179,  -3011},
    {18172,  -3055},
    {18164,  -3098},
    {18157,  -3142},
    {18149,  -3185},
    {18141,  -3229},
    {18134,  -3272},
    {18126,  -3316},
    {18118,  -3359},
    {18109,  -3403},
    {18101,  -3446},
    {18094,  -3489},
    {18085,  -3533},
    {18076,  -3576},
    {18068,  -3619},
    {18059,  -3663},
    {18050,  -3706},
    {18041,  -3749},
    {18032,  -3792},
    {18023,  -3836},
    {18014,  -3879},
    {18005,  -3922},
    {17995,  -3965},
    {17986,  -4008},
    {17975,  -4051},
    {17966,  -4094},
    {17956,  -4138},
    {17946,  -4180},
    {17936,  -4224},
    {17926,  -4266},
    {17916,  -4309},
    {17905,  -4353},
    {17895,  -4395},
    {17884,  -4438},
    {17874,  -4481},
    {17863,  -4524},
    {17852,  -4567},
    {17841,  -4609},
    {17830,  -4652},
    {17819,  -4695},
    {17807,  -4738},
    {17796,  -4780},
    {17784,  -4823},
    {17772,  -4865},
    {17761,  -4908},
    {17749,  -4951},
    {17738,  -4993},
    {17725,  -5036},
    {17713,  -5078},
    {17701,  -5121},
    {17689,  -5163},
    {17676,  -5205},
    {17664,  -5248},
    {17651,  -5290},
    {17638,  -5333},
    {17626,  -5375},
    {17613,  -5417},
    {17599,  -5459},
    {17586,  -5501},
    {17573,  -5544},
    {17560,  -5586},
    {17546,  -5627},
    {17533,  -5670},
    {17519,  -5712},
    {17505,  -5753},
    {17492,  -5795},
    {17478,  -5837},
    {17464,  -5879},
    {17450,  -5921},
    {17435,  -5963},
    {17421,  -6005},
    {17406,  -6046},
    {17392,  -6088},
    {17377,  -6130},
    {17363,  -6172},
    {17348,  -6213},
    {17333,  -6254},
    {17318,  -6296},
    {17303,  -6338},
    {17288,  -6379},
    {17272,  -6420},
    {17257,  -6462},
    {17241,  -6503},
    {17225,  -6545},
    {17210,  -6586},
    {17194,  -6627},
    {17178,  -6668},
    {17162,  -6709},
    {17145,  -6750},
    {17130,  -6791},
    {17113,  -6832},
    {17097,  -6874},
    {17080,  -6915},
    {17064,  -6956},
    {17047,  -6996},
    {17030,  -7037},
    {17013,  -7078},
    {16996,  -7119},
    {16979,  -7159},
    {16962,  -7200},
    {16945,  -7241},
    {16927,  -7281},
    {16910,  -7322},
    {16892,  -7362},
    {16874,  -7403},
    {16856,  -7444},
    {16838,  -7484},
    {16821,  -7524},
    {16802,  -7564},
    {16784,  -7605},
    {16766,  -7645},
    {16748,  -7685},
    {16729,  -7725},
    {16711,  -7765},
    {16692,  -7805},
    {16674,  -7845},
    {16654,  -7885},
    {16635,  -7925},
    {16616,  -7964},
    {16597,  -8004},
    {16578,  -8044},
    {16559,  -8084},
    {16539,  -8124},
    {16520,  -8164},
    {16500,  -8203},
    {16480,  -8242},
    {16461,  -8282},
    {16441,  -8322},
    {16421,  -8361},
    {16401,  -8400},
    {16380,  -8440},
    {16360,  -8479},
    {16340,  -8518},
    {16319,  -8557},
    {16299,  -8597},
    {16278,  -8635},
    {16257,  -8674},
    {16237,  -8713},
    {16215,  -8752},
    {16195,  -8791},
    {16173,  -8829},
    {16152,  -8868},
    {16131,  -8907},
    {16110,  -8946},
    {16088,  -8985},
    {16067,  -9023},
    {16045,  -9061},
    {16023,  -9100},
    {16001,  -9138},
    {15979,  -9176},
    {15957,  -9215},
    {15935,  -9253},
    {15913,  -9291},
    {15891,  -9329},
    {15868,  -9367},
    {15846,  -9405},
    {15823,  -9443},
    {15800,  -9481},
    {15778,  -9519},
    {15755,  -9557},
    {15732,  -9595},
    {15709,  -9632},
    {15686,  -9670},
    {15662,  -9708},
    {15639,  -9745},
    {15615,  -9782},
    {15592,  -9820},
    {15569,  -9857},
    {15544,  -9894},
    {15521,  -9932},
    {15497,  -9969},
    {15473, -10006},
    {15449, -10043},
    {15425, -10080},
    {15401, -10117},
    {15377, -10154},
    {15352, -10191},
    {15327, -10227},
    {15303, -10264},
    {15278, -10301},
    {15254, -10337},
    {15229, -10374},
    {15204, -10411},
    {15180, -10447},
    {15154, -10483},
    {15129, -10519},
    {15104, -10556},
    {15078, -10592},
    {15053, -10628},
    {15027, -10664},
    {15002, -10700},
    {14976, -10736},
    {14950, -10772},
    {14924, -10808},
    {14898, -10844},
    {14872, -10879},
    {14846, -10915},
    {14820, -10950},
    {14794, -10985},
    {14767, -11021},
    {14741, -11056},
    {14714, -11092},
    {14687, -11127},
    {14661, -11162},
    {14635, -11197},
    {14607, -11232},
    {14581, -11267},
    {14554, -11302},
    {14526, -11337},
    {14499, -11372},
    {14472, -11407},
    {14444, -11441},
    {14417, -11476},
    {14389, -11511},
    {14362, -11545},
    {14334, -11579},
    {14306, -11614},
    {14278, -11648},
    {14251, -11682},
    {14222, -11716},
    {14194, -11750},
    {14166, -11784},
    {14137, -11818},
    {14109, -11852},
    {14081, -11886},
    {14053, -11919},
    {14023, -11953},
    {13995, -11987},
    {13966, -12020},
    {13937, -12054},
    {13909, -12087},
    {13879, -12120},
    {13851, -12153},
    {13821, -12187},
    {13792, -12220},
    {13763, -12253},
    {13733, -12286},
    {13704, -12319},
    {13674, -12351},
    {13645, -12385},
    {13615, -12417},
    {13585, -12450},
    {13555, -12482},
    {13525, -12514},
    {13495, -12546},
    {13465, -12579},
    {13435, -12611},
    {13405, -12644},
    {13374, -12676},
    {13345, -12708},
    {13314, -12739},
    {13283, -12772}
};

static const cos_msin_t *s_cos_msin_table[] =
{
    s_cos_msin_2,
    s_cos_msin_4,
    s_cos_msin_8,
    s_cos_msin_16,
    s_cos_msin_32,
    s_cos_msin_64
};

/*- End of file ------------------------------------------------------------*/
