#define RX_PULSESHAPER_GAIN        1.000000f
#define RX_PULSESHAPER_COEFF_SETS  48
static const float rx_pulseshaper_re[RX_PULSESHAPER_COEFF_SETS][27] =
{
    {
          -0.0002255872f,     /* Filter 0 */
           0.0010772212f,
          -0.0020489447f,
           0.0027904154f,
          -0.0024613384f,
           0.0016519063f,
          -0.0046141775f,
          -0.0019967001f,
          -0.0042213211f,
          -0.0233976901f,
           0.0257378164f,
          -0.0418758474f,
           0.0466891744f,
           0.3227157380f,
           0.0753364929f,
          -0.1782016926f,
          -0.0305229947f,
          -0.0232941017f,
          -0.0367764365f,
           0.0007147686f,
          -0.0127244656f,
          -0.0014302683f,
          -0.0045579424f,
          -0.0020412235f,
          -0.0020619065f,
          -0.0037295073f,
          -0.0000888673f
    },
    {
          -0.0002275045f,     /* Filter 1 */
           0.0009871039f,
          -0.0020910004f,
           0.0027251726f,
          -0.0025870146f,
           0.0016252861f,
          -0.0048916464f,
          -0.0019896284f,
          -0.0048397188f,
          -0.0237455028f,
           0.0251964799f,
          -0.0443225478f,
           0.0474524780f,
           0.3241661780f,
           0.0749845580f,
          -0.1752765433f,
          -0.0287604570f,
          -0.0237602556f,
          -0.0362156056f,
           0.0006115934f,
          -0.0127572528f,
          -0.0013441756f,
          -0.0046259384f,
          -0.0019355976f,
          -0.0021082375f,
          -0.0036506231f,
          -0.0000961620f
    },
    {
          -0.0002292356f,     /* Filter 2 */
           0.0008953512f,
          -0.0021317304f,
           0.0026574255f,
          -0.0027108763f,
           0.0015966923f,
          -0.0051685871f,
          -0.0019806027f,
          -0.0054668817f,
          -0.0240839365f,
           0.0246287071f,
          -0.0467972792f,
           0.0482124309f,
           0.3255589646f,
           0.0746194196f,
          -0.1723405821f,
          -0.0270191676f,
          -0.0242027907f,
          -0.0356412303f,
           0.0005100000f,
          -0.0127779299f,
          -0.0012580756f,
          -0.0046884762f,
          -0.0018286776f,
          -0.0021526634f,
          -0.0035694823f,
          -0.0001033121f
    },
    {
          -0.0002307776f,     /* Filter 3 */
           0.0008020327f,
          -0.0021710931f,
           0.0025872148f,
          -0.0028327978f,
           0.0015661291f,
          -0.0054447492f,
          -0.0019695990f,
          -0.0061025091f,
          -0.0244126095f,
           0.0240343336f,
          -0.0492994388f,
           0.0489687748f,
           0.3268935535f,
           0.0742412161f,
          -0.1693947992f,
          -0.0252995186f,
          -0.0246218736f,
          -0.0350539120f,
           0.0004100342f,
          -0.0127866782f,
          -0.0011720449f,
          -0.0047455578f,
          -0.0017205660f,
          -0.0021951585f,
          -0.0034861718f,
          -0.0001103122f
    },
    {
          -0.0002321276f,     /* Filter 4 */
           0.0007072103f,
          -0.0022090444f,
           0.0025145856f,
          -0.0029526533f,
           0.0015336029f,
          -0.0057198731f,
          -0.0019565932f,
          -0.0067462847f,
          -0.0247311428f,
           0.0234132130f,
          -0.0518284449f,
           0.0497212515f,
           0.3281694617f,
           0.0738500836f,
          -0.1664401728f,
          -0.0236018860f,
          -0.0250176852f,
          -0.0344542448f,
           0.0003117406f,
          -0.0127836805f,
          -0.0010861574f,
          -0.0047971886f,
          -0.0016113720f,
          -0.0022357000f,
          -0.0034007733f,
          -0.0001171583f
    },
    {
          -0.0002332832f,     /* Filter 5 */
           0.0006109549f,
          -0.0022455442f,
           0.0024395825f,
          -0.0030703178f,
           0.0014991220f,
          -0.0059936966f,
          -0.0019415623f,
          -0.0073978880f,
          -0.0250391496f,
           0.0227652173f,
          -0.0543836682f,
           0.0504696014f,
           0.3293862057f,
           0.0734461719f,
          -0.1634776964f,
          -0.0219266458f,
          -0.0253904152f,
          -0.0338428277f,
           0.0002151614f,
          -0.0127691311f,
          -0.0010004881f,
          -0.0048433801f,
          -0.0015011959f,
          -0.0022742667f,
          -0.0033133678f,
          -0.0001238455f
    },
    {
          -0.0002342418f,     /* Filter 6 */
           0.0005133336f,
          -0.0022805536f,
           0.0023622545f,
          -0.0031856701f,
           0.0014626959f,
          -0.0062659606f,
          -0.0019244846f,
          -0.0080569843f,
          -0.0253362547f,
           0.0220902122f,
          -0.0569644843f,
           0.0512135691f,
           0.3305433046f,
           0.0730296300f,
          -0.1605083564f,
          -0.0202741482f,
          -0.0257402535f,
          -0.0332202557f,
           0.0001203382f,
          -0.0127432290f,
          -0.0009151099f,
          -0.0048841463f,
          -0.0013901463f,
          -0.0023108391f,
          -0.0032240442f,
          -0.0001303693f
    },
    {
          -0.0002350011f,     /* Filter 7 */
           0.0004144205f,
          -0.0023140327f,
           0.0022826512f,
          -0.0032985844f,
           0.0014243364f,
          -0.0065363981f,
          -0.0019053410f,
          -0.0087232308f,
          -0.0256220747f,
           0.0213880887f,
          -0.0595702454f,
           0.0519528957f,
           0.3316403995f,
           0.0726006106f,
          -0.1575331331f,
          -0.0186447416f,
          -0.0260674081f,
          -0.0325871180f,
           0.0000273092f,
          -0.0127061747f,
          -0.0008300950f,
          -0.0049195054f,
          -0.0012783271f,
          -0.0023454000f,
          -0.0031328855f,
          -0.0001367258f
    },
    {
          -0.0002355590f,     /* Filter 8 */
           0.0003142843f,
          -0.0023459445f,
           0.0022008259f,
          -0.0034089378f,
           0.0013840565f,
          -0.0068047424f,
          -0.0018841113f,
          -0.0093962743f,
          -0.0258962331f,
           0.0206587490f,
          -0.0622002845f,
           0.0526873296f,
           0.3326769857f,
           0.0721592734f,
          -0.1545530146f,
          -0.0170387579f,
          -0.0263720939f,
          -0.0319440023f,
          -0.0000638882f,
          -0.0126581845f,
          -0.0007455134f,
          -0.0049494845f,
          -0.0011658419f,
          -0.0023779327f,
          -0.0030399798f,
          -0.0001429107f
    },
    {
          -0.0002359134f,     /* Filter 9 */
           0.0002129997f,
          -0.0023762496f,
           0.0021168342f,
          -0.0035166109f,
           0.0013418720f,
          -0.0070707263f,
          -0.0018607775f,
          -0.0100757513f,
          -0.0261583498f,
           0.0199020969f,
          -0.0648539333f,
           0.0534166146f,
           0.3336527424f,
           0.0717057869f,
          -0.1515689653f,
          -0.0154565158f,
          -0.0266545289f,
          -0.0312914991f,
          -0.0001532180f,
          -0.0125994670f,
          -0.0006614353f,
          -0.0049741065f,
          -0.0010527980f,
          -0.0024084239f,
          -0.0029454189f,
          -0.0001489206f
    },
    {
          -0.0002360624f,     /* Filter 10 */
           0.0001106457f,
          -0.0024049153f,
           0.0020307330f,
          -0.0036214854f,
           0.0012977996f,
          -0.0073340784f,
          -0.0018353240f,
          -0.0107612899f,
          -0.0264080456f,
           0.0191180538f,
          -0.0675304887f,
           0.0541404956f,
           0.3345672589f,
           0.0712403148f,
          -0.1485819667f,
          -0.0138983208f,
          -0.0269149412f,
          -0.0306301910f,
          -0.0002406474f,
          -0.0125302396f,
          -0.0005779288f,
          -0.0049934088f,
          -0.0009392972f,
          -0.0024368605f,
          -0.0028492882f,
          -0.0001547513f
    },
    {
          -0.0002360044f,     /* Filter 11 */
           0.0000072962f,
          -0.0024319051f,
           0.0019425826f,
          -0.0037234402f,
           0.0012518575f,
          -0.0075945285f,
          -0.0018077349f,
          -0.0114525069f,
          -0.0266449530f,
           0.0183065518f,
          -0.0702292589f,
           0.0548587201f,
           0.3354202137f,
           0.0707630243f,
          -0.1455930052f,
          -0.0123644684f,
          -0.0271535702f,
          -0.0299606569f,
          -0.0003261437f,
          -0.0124507320f,
          -0.0004950602f,
          -0.0050074246f,
          -0.0008254433f,
          -0.0024632328f,
          -0.0027516756f,
          -0.0001603995f
    },
    {
          -0.0002357379f,     /* Filter 12 */
          -0.0000969713f,
          -0.0024571849f,
           0.0018524437f,
          -0.0038223595f,
           0.0012040677f,
          -0.0078518000f,
          -0.0017779973f,
          -0.0121490133f,
          -0.0268686949f,
           0.0174675392f,
          -0.0729495201f,
           0.0555710382f,
           0.3362112915f,
           0.0702740993f,
          -0.1426030329f,
          -0.0108552443f,
          -0.0273706579f,
          -0.0292834752f,
          -0.0004096775f,
          -0.0123611702f,
          -0.0004128962f,
          -0.0050161963f,
          -0.0007113378f,
          -0.0024875330f,
          -0.0026526758f,
          -0.0001658620f
    },
    {
          -0.0002352615f,     /* Filter 13 */
          -0.0002020749f,
          -0.0024807241f,
           0.0017603822f,
          -0.0039181269f,
           0.0011544503f,
          -0.0081056228f,
          -0.0017460976f,
          -0.0128504066f,
          -0.0270788976f,
           0.0166009646f,
          -0.0756905423f,
           0.0562772022f,
           0.3369401960f,
           0.0697737216f,
          -0.1396130136f,
          -0.0093709121f,
          -0.0275664600f,
          -0.0285992217f,
          -0.0004912199f,
          -0.0122617888f,
          -0.0003314995f,
          -0.0050197673f,
          -0.0005970840f,
          -0.0025097527f,
          -0.0025523730f,
          -0.0001711354f
    },
    {
          -0.0002345739f,     /* Filter 14 */
          -0.0003079322f,
          -0.0025024909f,
           0.0016664628f,
          -0.0040106281f,
           0.0011030318f,
          -0.0083557204f,
          -0.0017120255f,
          -0.0135562762f,
          -0.0272751934f,
           0.0157068004f,
          -0.0784515724f,
           0.0569769519f,
           0.3376066341f,
           0.0692620702f,
          -0.1366239180f,
          -0.0079117353f,
          -0.0277412306f,
          -0.0279084621f,
          -0.0005707451f,
          -0.0121528275f,
          -0.0002509341f,
          -0.0050181849f,
          -0.0004827837f,
          -0.0025298884f,
          -0.0024508655f,
          -0.0001762169f
    },
    {
          -0.0002336743f,     /* Filter 15 */
          -0.0004144665f,
          -0.0025224541f,
           0.0015707543f,
          -0.0040997524f,
           0.0010498359f,
          -0.0086018170f,
          -0.0016757712f,
          -0.0142662044f,
          -0.0274572178f,
           0.0147850271f,
          -0.0812318644f,
           0.0576700502f,
           0.3382103275f,
           0.0687393345f,
          -0.1336366907f,
          -0.0064779557f,
          -0.0278952373f,
          -0.0272117582f,
          -0.0006482276f,
          -0.0120345250f,
          -0.0001712606f,
          -0.0050115039f,
          -0.0003685390f,
          -0.0025479356f,
          -0.0023482397f,
          -0.0001811037f
    },
    {
          -0.0002325617f,     /* Filter 16 */
          -0.0005215883f,
          -0.0025405864f,
           0.0014733283f,
          -0.0041853880f,
           0.0009948916f,
          -0.0088436386f,
          -0.0016373263f,
          -0.0149797642f,
          -0.0276246022f,
           0.0138356301f,
          -0.0840306457f,
           0.0583562562f,
           0.3387511245f,
           0.0682057069f,
          -0.1306522782f,
          -0.0050698048f,
          -0.0280287578f,
          -0.0265096776f,
          -0.0007236441f,
          -0.0119071307f,
          -0.0000925386f,
          -0.0049997803f,
          -0.0002544469f,
          -0.0025638940f,
          -0.0022445889f,
          -0.0001857931f
    },
    {
          -0.0002312353f,     /* Filter 17 */
          -0.0006292185f,
          -0.0025568618f,
           0.0013742551f,
          -0.0042674275f,
           0.0009382281f,
          -0.0090809063f,
          -0.0015966847f,
          -0.0156965162f,
          -0.0277769912f,
           0.0128586169f,
          -0.0868471324f,
           0.0590353166f,
           0.3392287675f,
           0.0676613773f,
          -0.1276716186f,
          -0.0036874988f,
          -0.0281420647f,
          -0.0258027739f,
          -0.0007969746f,
          -0.0117708870f,
          -0.0000148270f,
          -0.0049830706f,
          -0.0001406071f,
          -0.0025777636f,
          -0.0021400055f,
          -0.0001902827f
    },
    {
          -0.0002296949f,     /* Filter 18 */
          -0.0007372681f,
          -0.0025712503f,
           0.0012736106f,
          -0.0043457630f,
           0.0008798771f,
          -0.0093133450f,
          -0.0015538410f,
          -0.0164160198f,
          -0.0279140251f,
           0.0118540046f,
          -0.0896805216f,
           0.0597069972f,
           0.3396430866f,
           0.0671065597f,
          -0.1246956673f,
          -0.0023312476f,
          -0.0282354500f,
          -0.0250915936f,
          -0.0008681988f,
          -0.0116260558f,
           0.0000618176f,
          -0.0049614426f,
          -0.0000271166f,
          -0.0025895460f,
          -0.0020345799f,
          -0.0001945702f
    },
    {
          -0.0002279401f,     /* Filter 19 */
          -0.0008456543f,
          -0.0025837316f,
           0.0011714716f,
          -0.0044202915f,
           0.0008198714f,
          -0.0095406775f,
          -0.0015087910f,
          -0.0171378180f,
          -0.0280353473f,
           0.0108218242f,
          -0.0925300161f,
           0.0603710541f,
           0.3399939607f,
           0.0665414417f,
          -0.1217253322f,
          -0.0010012477f,
          -0.0283092030f,
          -0.0243766792f,
          -0.0009372986f,
          -0.0114728855f,
           0.0001373402f,
          -0.0049349593f,
           0.0000859258f,
          -0.0025992464f,
          -0.0019284058f,
          -0.0001986536f
    },
    {
          -0.0002259705f,     /* Filter 20 */
          -0.0009542871f,
          -0.0025942816f,
           0.0010679155f,
          -0.0044909097f,
           0.0007582451f,
          -0.0097626270f,
          -0.0014615333f,
          -0.0178614493f,
          -0.0281406040f,
           0.0097621099f,
          -0.0953947966f,
           0.0610272510f,
           0.3402811755f,
           0.0659662416f,
          -0.1187615389f,
           0.0003023311f,
          -0.0283636203f,
          -0.0236585774f,
          -0.0010042585f,
          -0.0113116356f,
           0.0002116873f,
          -0.0049036953f,
           0.0001984275f,
          -0.0026068687f,
          -0.0018215759f,
          -0.0002025310f
    },
    {
          -0.0002237865f,     /* Filter 21 */
          -0.0010630796f,
          -0.0026028786f,
           0.0009630217f,
          -0.0045575184f,
           0.0006950360f,
          -0.0099789231f,
          -0.0014120671f,
          -0.0185864475f,
          -0.0282294528f,
           0.0086749174f,
          -0.0982740298f,
           0.0616753532f,
           0.3405046930f,
           0.0653811602f,
          -0.1158052202f,
           0.0015793088f,
          -0.0283990101f,
          -0.0229378136f,
          -0.0010690639f,
          -0.0111425708f,
           0.0002848063f,
          -0.0048677212f,
           0.0003102929f,
          -0.0026124209f,
          -0.0017141812f,
          -0.0002062007f
    },
    {
          -0.0002213879f,     /* Filter 22 */
          -0.0011719437f,
          -0.0026095012f,
           0.0008568735f,
          -0.0046200208f,
           0.0006302820f,
          -0.0101892831f,
          -0.0013603937f,
          -0.0193123302f,
          -0.0283015482f,
           0.0075603134f,
          -0.1011668788f,
           0.0623151315f,
           0.3406644084f,
           0.0647864110f,
          -0.1128572498f,
           0.0028295415f,
          -0.0284156811f,
          -0.0222149183f,
          -0.0011317024f,
          -0.0109659520f,
           0.0003566476f,
          -0.0048271153f,
           0.0004214283f,
          -0.0026159113f,
          -0.0016063144f,
          -0.0002096613f
    },
    {
          -0.0002187756f,     /* Filter 23 */
          -0.0012807894f,
          -0.0026141320f,
           0.0007495544f,
          -0.0046783235f,
           0.0005640234f,
          -0.0103934397f,
          -0.0013065154f,
          -0.0200386163f,
          -0.0283565494f,
           0.0064183775f,
          -0.1040724930f,
           0.0629463524f,
           0.3407602619f,
           0.0641822150f,
          -0.1099185532f,
           0.0040528797f,
          -0.0284139469f,
          -0.0214904145f,
          -0.0011921632f,
          -0.0107820433f,
           0.0004271619f,
          -0.0047819563f,
           0.0005317429f,
          -0.0026173521f,
          -0.0014980664f,
          -0.0002129114f
    },
    {
          -0.0002159498f,     /* Filter 24 */
          -0.0013895273f,
          -0.0026167546f,
           0.0006411480f,
          -0.0047323313f,
           0.0004963023f,
          -0.0105911158f,
          -0.0012504366f,
          -0.0207648111f,
          -0.0283941279f,
           0.0052491967f,
          -0.1069900047f,
           0.0635687875f,
           0.3407922346f,
           0.0635687875f,
          -0.1069900047f,
           0.0052491967f,
          -0.0283941279f,
          -0.0207648111f,
          -0.0012504366f,
          -0.0105911158f,
           0.0004963023f,
          -0.0047323313f,
           0.0006411480f,
          -0.0026167546f,
          -0.0013895273f,
          -0.0002159498f
    },
    {
          -0.0002129114f,     /* Filter 25 */
          -0.0014980664f,
          -0.0026173521f,
           0.0005317429f,
          -0.0047819563f,
           0.0004271619f,
          -0.0107820433f,
          -0.0011921632f,
          -0.0214904145f,
          -0.0284139469f,
           0.0040528797f,
          -0.1099185532f,
           0.0641822150f,
           0.3407602619f,
           0.0629463524f,
          -0.1040724930f,
           0.0064183775f,
          -0.0283565494f,
          -0.0200386164f,
          -0.0013065154f,
          -0.0103934397f,
           0.0005640234f,
          -0.0046783235f,
           0.0007495544f,
          -0.0026141320f,
          -0.0012807894f,
          -0.0002187756f
    },
    {
          -0.0002096613f,     /* Filter 26 */
          -0.0016063144f,
          -0.0026159113f,
           0.0004214283f,
          -0.0048271153f,
           0.0003566476f,
          -0.0109659520f,
          -0.0011317024f,
          -0.0222149182f,
          -0.0284156811f,
           0.0028295415f,
          -0.1128572498f,
           0.0647864110f,
           0.3406644084f,
           0.0623151315f,
          -0.1011668788f,
           0.0075603134f,
          -0.0283015482f,
          -0.0193123302f,
          -0.0013603937f,
          -0.0101892831f,
           0.0006302820f,
          -0.0046200208f,
           0.0008568735f,
          -0.0026095012f,
          -0.0011719437f,
          -0.0002213879f
    },
    {
          -0.0002062007f,     /* Filter 27 */
          -0.0017141812f,
          -0.0026124209f,
           0.0003102929f,
          -0.0048677212f,
           0.0002848063f,
          -0.0111425708f,
          -0.0010690639f,
          -0.0229378136f,
          -0.0283990101f,
           0.0015793088f,
          -0.1158052202f,
           0.0653811602f,
           0.3405046930f,
           0.0616753532f,
          -0.0982740298f,
           0.0086749174f,
          -0.0282294527f,
          -0.0185864475f,
          -0.0014120671f,
          -0.0099789231f,
           0.0006950360f,
          -0.0045575184f,
           0.0009630217f,
          -0.0026028786f,
          -0.0010630796f,
          -0.0002237865f
    },
    {
          -0.0002025310f,     /* Filter 28 */
          -0.0018215759f,
          -0.0026068687f,
           0.0001984275f,
          -0.0049036953f,
           0.0002116873f,
          -0.0113116356f,
          -0.0010042585f,
          -0.0236585774f,
          -0.0283636203f,
           0.0003023310f,
          -0.1187615389f,
           0.0659662416f,
           0.3402811755f,
           0.0610272510f,
          -0.0953947966f,
           0.0097621099f,
          -0.0281406040f,
          -0.0178614493f,
          -0.0014615333f,
          -0.0097626270f,
           0.0007582451f,
          -0.0044909097f,
           0.0010679155f,
          -0.0025942816f,
          -0.0009542871f,
          -0.0002259705f
    },
    {
          -0.0001986536f,     /* Filter 29 */
          -0.0019284058f,
          -0.0025992464f,
           0.0000859258f,
          -0.0049349593f,
           0.0001373402f,
          -0.0114728855f,
          -0.0009372986f,
          -0.0243766792f,
          -0.0283092030f,
          -0.0010012477f,
          -0.1217253322f,
           0.0665414417f,
           0.3399939607f,
           0.0603710541f,
          -0.0925300161f,
           0.0108218242f,
          -0.0280353473f,
          -0.0171378180f,
          -0.0015087910f,
          -0.0095406775f,
           0.0008198714f,
          -0.0044202915f,
           0.0011714716f,
          -0.0025837316f,
          -0.0008456543f,
          -0.0002279401f
    },
    {
          -0.0001945702f,     /* Filter 30 */
          -0.0020345799f,
          -0.0025895460f,
          -0.0000271166f,
          -0.0049614426f,
           0.0000618176f,
          -0.0116260558f,
          -0.0008681988f,
          -0.0250915936f,
          -0.0282354500f,
          -0.0023312476f,
          -0.1246956674f,
           0.0671065597f,
           0.3396430866f,
           0.0597069972f,
          -0.0896805216f,
           0.0118540046f,
          -0.0279140251f,
          -0.0164160198f,
          -0.0015538410f,
          -0.0093133450f,
           0.0008798771f,
          -0.0043457630f,
           0.0012736106f,
          -0.0025712503f,
          -0.0007372681f,
          -0.0002296949f
    },
    {
          -0.0001902827f,     /* Filter 31 */
          -0.0021400055f,
          -0.0025777636f,
          -0.0001406071f,
          -0.0049830706f,
          -0.0000148270f,
          -0.0117708870f,
          -0.0007969746f,
          -0.0258027739f,
          -0.0281420646f,
          -0.0036874988f,
          -0.1276716186f,
           0.0676613773f,
           0.3392287675f,
           0.0590353166f,
          -0.0868471324f,
           0.0128586169f,
          -0.0277769912f,
          -0.0156965162f,
          -0.0015966847f,
          -0.0090809063f,
           0.0009382281f,
          -0.0042674275f,
           0.0013742551f,
          -0.0025568618f,
          -0.0006292185f,
          -0.0002312353f
    },
    {
          -0.0001857931f,     /* Filter 32 */
          -0.0022445889f,
          -0.0025638940f,
          -0.0002544469f,
          -0.0049997803f,
          -0.0000925386f,
          -0.0119071307f,
          -0.0007236441f,
          -0.0265096776f,
          -0.0280287578f,
          -0.0050698048f,
          -0.1306522782f,
           0.0682057069f,
           0.3387511245f,
           0.0583562562f,
          -0.0840306457f,
           0.0138356301f,
          -0.0276246022f,
          -0.0149797642f,
          -0.0016373263f,
          -0.0088436386f,
           0.0009948916f,
          -0.0041853880f,
           0.0014733283f,
          -0.0025405864f,
          -0.0005215883f,
          -0.0002325617f
    },
    {
          -0.0001811037f,     /* Filter 33 */
          -0.0023482397f,
          -0.0025479356f,
          -0.0003685390f,
          -0.0050115039f,
          -0.0001712606f,
          -0.0120345250f,
          -0.0006482276f,
          -0.0272117582f,
          -0.0278952373f,
          -0.0064779557f,
          -0.1336366907f,
           0.0687393345f,
           0.3382103275f,
           0.0576700502f,
          -0.0812318644f,
           0.0147850271f,
          -0.0274572178f,
          -0.0142662044f,
          -0.0016757712f,
          -0.0086018170f,
           0.0010498359f,
          -0.0040997524f,
           0.0015707543f,
          -0.0025224541f,
          -0.0004144665f,
          -0.0002336743f
    },
    {
          -0.0001762169f,     /* Filter 34 */
          -0.0024508655f,
          -0.0025298884f,
          -0.0004827837f,
          -0.0050181849f,
          -0.0002509341f,
          -0.0121528275f,
          -0.0005707451f,
          -0.0279084621f,
          -0.0277412306f,
          -0.0079117353f,
          -0.1366239180f,
           0.0692620702f,
           0.3376066341f,
           0.0569769519f,
          -0.0784515724f,
           0.0157068004f,
          -0.0272751934f,
          -0.0135562762f,
          -0.0017120255f,
          -0.0083557204f,
           0.0011030318f,
          -0.0040106281f,
           0.0016664628f,
          -0.0025024909f,
          -0.0003079322f,
          -0.0002345739f
    },
    {
          -0.0001711354f,     /* Filter 35 */
          -0.0025523730f,
          -0.0025097527f,
          -0.0005970840f,
          -0.0050197673f,
          -0.0003314995f,
          -0.0122617888f,
          -0.0004912199f,
          -0.0285992217f,
          -0.0275664600f,
          -0.0093709121f,
          -0.1396130136f,
           0.0697737216f,
           0.3369401960f,
           0.0562772022f,
          -0.0756905422f,
           0.0166009646f,
          -0.0270788976f,
          -0.0128504066f,
          -0.0017460976f,
          -0.0081056228f,
           0.0011544503f,
          -0.0039181269f,
           0.0017603822f,
          -0.0024807241f,
          -0.0002020749f,
          -0.0002352615f
    },
    {
          -0.0001658620f,     /* Filter 36 */
          -0.0026526758f,
          -0.0024875330f,
          -0.0007113378f,
          -0.0050161963f,
          -0.0004128962f,
          -0.0123611702f,
          -0.0004096775f,
          -0.0292834752f,
          -0.0273706579f,
          -0.0108552443f,
          -0.1426030329f,
           0.0702740993f,
           0.3362112915f,
           0.0555710382f,
          -0.0729495201f,
           0.0174675393f,
          -0.0268686949f,
          -0.0121490134f,
          -0.0017779973f,
          -0.0078518000f,
           0.0012040677f,
          -0.0038223595f,
           0.0018524437f,
          -0.0024571849f,
          -0.0000969713f,
          -0.0002357379f
    },
    {
          -0.0001603995f,     /* Filter 37 */
          -0.0027516756f,
          -0.0024632328f,
          -0.0008254433f,
          -0.0050074246f,
          -0.0004950602f,
          -0.0124507320f,
          -0.0003261437f,
          -0.0299606569f,
          -0.0271535702f,
          -0.0123644684f,
          -0.1455930052f,
           0.0707630243f,
           0.3354202136f,
           0.0548587201f,
          -0.0702292589f,
           0.0183065518f,
          -0.0266449530f,
          -0.0114525069f,
          -0.0018077349f,
          -0.0075945285f,
           0.0012518575f,
          -0.0037234402f,
           0.0019425826f,
          -0.0024319051f,
           0.0000072962f,
          -0.0002360044f
    },
    {
          -0.0001547513f,     /* Filter 38 */
          -0.0028492882f,
          -0.0024368605f,
          -0.0009392972f,
          -0.0049934088f,
          -0.0005779288f,
          -0.0125302396f,
          -0.0002406474f,
          -0.0306301910f,
          -0.0269149412f,
          -0.0138983208f,
          -0.1485819667f,
           0.0712403148f,
           0.3345672589f,
           0.0541404956f,
          -0.0675304887f,
           0.0191180538f,
          -0.0264080456f,
          -0.0107612899f,
          -0.0018353240f,
          -0.0073340784f,
           0.0012977996f,
          -0.0036214854f,
           0.0020307330f,
          -0.0024049153f,
           0.0001106457f,
          -0.0002360624f
    },
    {
          -0.0001489206f,     /* Filter 39 */
          -0.0029454189f,
          -0.0024084239f,
          -0.0010527980f,
          -0.0049741065f,
          -0.0006614353f,
          -0.0125994671f,
          -0.0001532180f,
          -0.0312914991f,
          -0.0266545289f,
          -0.0154565158f,
          -0.1515689653f,
           0.0717057869f,
           0.3336527424f,
           0.0534166146f,
          -0.0648539333f,
           0.0199020969f,
          -0.0261583498f,
          -0.0100757513f,
          -0.0018607775f,
          -0.0070707263f,
           0.0013418720f,
          -0.0035166109f,
           0.0021168342f,
          -0.0023762496f,
           0.0002129997f,
          -0.0002359134f
    },
    {
          -0.0001429107f,     /* Filter 40 */
          -0.0030399798f,
          -0.0023779327f,
          -0.0011658419f,
          -0.0049494845f,
          -0.0007455134f,
          -0.0126581845f,
          -0.0000638882f,
          -0.0319440023f,
          -0.0263720939f,
          -0.0170387579f,
          -0.1545530146f,
           0.0721592734f,
           0.3326769857f,
           0.0526873296f,
          -0.0622002845f,
           0.0206587490f,
          -0.0258962331f,
          -0.0093962743f,
          -0.0018841113f,
          -0.0068047424f,
           0.0013840565f,
          -0.0034089378f,
           0.0022008259f,
          -0.0023459445f,
           0.0003142843f,
          -0.0002355590f
    },
    {
          -0.0001367258f,     /* Filter 41 */
          -0.0031328855f,
          -0.0023454000f,
          -0.0012783271f,
          -0.0049195054f,
          -0.0008300950f,
          -0.0127061747f,
           0.0000273092f,
          -0.0325871180f,
          -0.0260674081f,
          -0.0186447416f,
          -0.1575331331f,
           0.0726006106f,
           0.3316403995f,
           0.0519528957f,
          -0.0595702454f,
           0.0213880887f,
          -0.0256220747f,
          -0.0087232308f,
          -0.0019053410f,
          -0.0065363981f,
           0.0014243364f,
          -0.0032985844f,
           0.0022826512f,
          -0.0023140327f,
           0.0004144205f,
          -0.0002350011f
    },
    {
          -0.0001303693f,     /* Filter 42 */
          -0.0032240442f,
          -0.0023108391f,
          -0.0013901463f,
          -0.0048841463f,
          -0.0009151099f,
          -0.0127432290f,
           0.0001203382f,
          -0.0332202557f,
          -0.0257402535f,
          -0.0202741482f,
          -0.1605083564f,
           0.0730296300f,
           0.3305433046f,
           0.0512135691f,
          -0.0569644843f,
           0.0220902122f,
          -0.0253362547f,
          -0.0080569843f,
          -0.0019244846f,
          -0.0062659606f,
           0.0014626959f,
          -0.0031856701f,
           0.0023622545f,
          -0.0022805536f,
           0.0005133336f,
          -0.0002342418f
    },
    {
          -0.0001238455f,     /* Filter 43 */
          -0.0033133678f,
          -0.0022742667f,
          -0.0015011959f,
          -0.0048433801f,
          -0.0010004881f,
          -0.0127691311f,
           0.0002151614f,
          -0.0338428277f,
          -0.0253904152f,
          -0.0219266458f,
          -0.1634776964f,
           0.0734461719f,
           0.3293862057f,
           0.0504696014f,
          -0.0543836682f,
           0.0227652173f,
          -0.0250391496f,
          -0.0073978880f,
          -0.0019415623f,
          -0.0059936966f,
           0.0014991220f,
          -0.0030703178f,
           0.0024395825f,
          -0.0022455442f,
           0.0006109549f,
          -0.0002332832f
    },
    {
          -0.0001171583f,     /* Filter 44 */
          -0.0034007733f,
          -0.0022357000f,
          -0.0016113720f,
          -0.0047971886f,
          -0.0010861574f,
          -0.0127836805f,
           0.0003117406f,
          -0.0344542448f,
          -0.0250176852f,
          -0.0236018860f,
          -0.1664401729f,
           0.0738500836f,
           0.3281694617f,
           0.0497212515f,
          -0.0518284449f,
           0.0234132131f,
          -0.0247311428f,
          -0.0067462847f,
          -0.0019565932f,
          -0.0057198731f,
           0.0015336029f,
          -0.0029526533f,
           0.0025145856f,
          -0.0022090444f,
           0.0007072103f,
          -0.0002321276f
    },
    {
          -0.0001103122f,     /* Filter 45 */
          -0.0034861718f,
          -0.0021951585f,
          -0.0017205660f,
          -0.0047455579f,
          -0.0011720449f,
          -0.0127866782f,
           0.0004100342f,
          -0.0350539120f,
          -0.0246218736f,
          -0.0252995186f,
          -0.1693947993f,
           0.0742412161f,
           0.3268935535f,
           0.0489687748f,
          -0.0492994388f,
           0.0240343336f,
          -0.0244126095f,
          -0.0061025091f,
          -0.0019695990f,
          -0.0054447492f,
           0.0015661291f,
          -0.0028327978f,
           0.0025872148f,
          -0.0021710931f,
           0.0008020327f,
          -0.0002307776f
    },
    {
          -0.0001033121f,     /* Filter 46 */
          -0.0035694823f,
          -0.0021526634f,
          -0.0018286776f,
          -0.0046884762f,
          -0.0012580756f,
          -0.0127779299f,
           0.0005100000f,
          -0.0356412303f,
          -0.0242027907f,
          -0.0270191676f,
          -0.1723405821f,
           0.0746194196f,
           0.3255589646f,
           0.0482124309f,
          -0.0467972792f,
           0.0246287071f,
          -0.0240839365f,
          -0.0054668817f,
          -0.0019806027f,
          -0.0051685871f,
           0.0015966923f,
          -0.0027108763f,
           0.0026574255f,
          -0.0021317304f,
           0.0008953512f,
          -0.0002292356f
    },
    {
          -0.0000961620f,     /* Filter 47 */
          -0.0036506231f,
          -0.0021082375f,
          -0.0019355976f,
          -0.0046259384f,
          -0.0013441756f,
          -0.0127572528f,
           0.0006115934f,
          -0.0362156056f,
          -0.0237602556f,
          -0.0287604570f,
          -0.1752765433f,
           0.0749845580f,
           0.3241661779f,
           0.0474524780f,
          -0.0443225478f,
           0.0251964799f,
          -0.0237455028f,
          -0.0048397188f,
          -0.0019896284f,
          -0.0048916464f,
           0.0016252861f,
          -0.0025870146f,
           0.0027251726f,
          -0.0020910004f,
           0.0009871039f,
          -0.0002275045f
    }
};
static const float rx_pulseshaper_im[RX_PULSESHAPER_COEFF_SETS][27] =
{
    {
          -0.0028663575f,     /* Filter 0 */
          -0.0003500104f,
          -0.0033435739f,
          -0.0027904154f,
          -0.0015083101f,
          -0.0050840449f,
          -0.0003631436f,
          -0.0126066685f,
           0.0017485284f,
          -0.0322041576f,
          -0.0301351111f,
          -0.0213368100f,
          -0.1944744073f,
           0.0000000000f,
           0.3137990765f,
           0.0907982975f,
          -0.0357378350f,
           0.0320615804f,
          -0.0152332987f,
          -0.0045128715f,
           0.0010014372f,
          -0.0044019132f,
           0.0027931107f,
          -0.0020412235f,
           0.0033647255f,
          -0.0012117904f,
           0.0011291658f
    },
    {
          -0.0028907191f,     /* Filter 1 */
          -0.0003207295f,
          -0.0034122025f,
          -0.0027251726f,
          -0.0015853246f,
          -0.0050021163f,
          -0.0003849809f,
          -0.0125620192f,
           0.0020046772f,
          -0.0326828808f,
          -0.0295012876f,
          -0.0225834661f,
          -0.1976537959f,
           0.0000000000f,
           0.3123331620f,
           0.0893078595f,
          -0.0336741686f,
           0.0327031863f,
          -0.0150009950f,
          -0.0038614490f,
           0.0010040176f,
          -0.0041369471f,
           0.0028347787f,
          -0.0019355976f,
           0.0034403309f,
          -0.0011861593f,
           0.0012218546f
    },
    {
          -0.0029127149f,     /* Filter 2 */
          -0.0002909172f,
          -0.0034786678f,
          -0.0026574255f,
          -0.0016612271f,
          -0.0049141135f,
          -0.0004067766f,
          -0.0125050331f,
           0.0022644566f,
          -0.0331486948f,
          -0.0288365110f,
          -0.0238444047f,
          -0.2008192272f,
           0.0000000000f,
           0.3108122511f,
           0.0878119126f,
          -0.0316353806f,
           0.0333122836f,
          -0.0147630810f,
          -0.0032200134f,
           0.0010056449f,
          -0.0038719586f,
           0.0028731019f,
          -0.0018286776f,
           0.0035128275f,
          -0.0011597951f,
           0.0013127044f
    },
    {
          -0.0029323077f,     /* Filter 3 */
          -0.0002605962f,
          -0.0035429020f,
          -0.0025872148f,
          -0.0017359407f,
          -0.0048200496f,
          -0.0004285111f,
          -0.0124355589f,
           0.0025277420f,
          -0.0336010744f,
          -0.0281405891f,
          -0.0251193187f,
          -0.2039696262f,
           0.0000000000f,
           0.3092369205f,
           0.0863109612f,
          -0.0296219304f,
           0.0338891017f,
          -0.0145198058f,
          -0.0025888544f,
           0.0010063334f,
          -0.0036071832f,
           0.0029080816f,
          -0.0017205660f,
           0.0035821731f,
          -0.0011327259f,
           0.0014016500f
    },
    {
          -0.0029494611f,     /* Filter 4 */
          -0.0002297865f,
          -0.0036048329f,
          -0.0025145856f,
          -0.0018093883f,
          -0.0047199445f,
          -0.0004501638f,
          -0.0123534430f,
           0.0027944026f,
          -0.0340394978f,
          -0.0274133503f,
          -0.0264079117f,
          -0.2071039176f,
           0.0000000000f,
           0.3076077361f,
           0.0848055039f,
          -0.0276342580f,
           0.0344338896f,
          -0.0142714155f,
          -0.0019682529f,
           0.0010060975f,
          -0.0033428487f,
           0.0029397209f,
          -0.0016113720f,
           0.0036483309f,
          -0.0011049782f,
           0.0014886367f
    },
    {
          -0.0029641442f,     /* Filter 5 */
          -0.0001985113f,
          -0.0036643951f,
          -0.0024395825f,
          -0.0018814932f,
          -0.0046138230f,
          -0.0004717142f,
          -0.0122585417f,
           0.0030643056f,
          -0.0344634328f,
          -0.0266546448f,
          -0.0277098630f,
          -0.2102210189f,
           0.0000000000f,
           0.3059253229f,
           0.0832960468f,
          -0.0256728037f,
           0.0349469084f,
          -0.0140181582f,
          -0.0013584756f,
           0.0010049524f,
          -0.0030791857f,
           0.0029680271f,
          -0.0015011959f,
           0.0037112660f,
          -0.0010765785f,
           0.0015736058f
    },
    {
          -0.0029763241f,     /* Filter 6 */
          -0.0001667922f,
          -0.0037215252f,
          -0.0023622545f,
          -0.0019521811f,
          -0.0045017152f,
          -0.0004931418f,
          -0.0121507178f,
           0.0033373122f,
          -0.0348723628f,
          -0.0258643154f,
          -0.0290248545f,
          -0.2133198677f,
           0.0000000000f,
           0.3041903010f,
           0.0817830924f,
          -0.0237379776f,
           0.0354284196f,
          -0.0137602804f,
          -0.0007597857f,
           0.0010029139f,
          -0.0028164188f,
           0.0029930087f,
          -0.0013901463f,
           0.0037709467f,
          -0.0010475555f,
           0.0016564989f
    },
    {
          -0.0029859721f,     /* Filter 7 */
          -0.0001346534f,
          -0.0037761582f,
          -0.0022826512f,
          -0.0020213751f,
          -0.0043836566f,
          -0.0005144257f,
          -0.0120298496f,
           0.0036132805f,
          -0.0352657604f,
          -0.0250422344f,
          -0.0303525561f,
          -0.2163993844f,
           0.0000000000f,
           0.3024033067f,
           0.0802671405f,
          -0.0218301876f,
           0.0358787093f,
          -0.0134980262f,
          -0.0001724233f,
           0.0009999976f,
          -0.0025547698f,
           0.0030146768f,
          -0.0012783271f,
           0.0038273449f,
          -0.0010179362f,
           0.0017372664f
    },
    {
          -0.0029930609f,     /* Filter 8 */
          -0.0001021172f,
          -0.0038282335f,
          -0.0022008259f,
          -0.0020889998f,
          -0.0042596878f,
          -0.0005355448f,
          -0.0118958109f,
           0.0038920642f,
          -0.0356431071f,
          -0.0241882872f,
          -0.0316926279f,
          -0.2194585217f,
           0.0000000000f,
           0.3005650049f,
           0.0787486942f,
          -0.0199498223f,
           0.0362980733f,
          -0.0132316390f,
           0.0004033739f,
           0.0009962207f,
          -0.0022944544f,
           0.0030330480f,
          -0.0011658419f,
           0.0038804334f,
          -0.0009877493f,
           0.0018158530f
    },
    {
          -0.0029975637f,     /* Filter 9 */
          -0.0000692078f,
          -0.0038776870f,
          -0.0021168342f,
          -0.0021549819f,
          -0.0041298574f,
          -0.0005564782f,
          -0.0117484865f,
           0.0041735128f,
          -0.0360038798f,
          -0.0233023615f,
          -0.0330447295f,
          -0.2224962126f,
           0.0000000000f,
           0.2986760977f,
           0.0772282452f,
          -0.0180972548f,
           0.0366868117f,
          -0.0129613633f,
           0.0009673802f,
           0.0009915996f,
          -0.0020356887f,
           0.0030481364f,
          -0.0010527980f,
           0.0039301906f,
          -0.0009570246f,
           0.0018922157f
    },
    {
          -0.0029994575f,     /* Filter 10 */
          -0.0000359510f,
          -0.0039244652f,
          -0.0020307330f,
          -0.0022192491f,
          -0.0039942164f,
          -0.0005772045f,
          -0.0115877798f,
           0.0044574722f,
          -0.0363475566f,
          -0.0223843650f,
          -0.0344085026f,
          -0.2255113940f,
           0.0000000000f,
           0.2967372670f,
           0.0757062934f,
          -0.0162728428f,
           0.0370452384f,
          -0.0126874405f,
           0.0015193877f,
           0.0009861512f,
          -0.0017786820f,
           0.0030599648f,
          -0.0009392972f,
           0.0039765949f,
          -0.0009257899f,
           0.0019663015f
    },
    {
          -0.0029987207f,     /* Filter 11 */
          -0.0000023707f,
          -0.0039685085f,
          -0.0019425826f,
          -0.0022817271f,
          -0.0038528212f,
          -0.0005977024f,
          -0.0114135888f,
           0.0047437837f,
          -0.0366736316f,
          -0.0214342183f,
          -0.0357835947f,
          -0.2285030143f,
           0.0000000000f,
           0.2947492090f,
           0.0741833414f,
          -0.0144769324f,
           0.0373736831f,
          -0.0124101104f,
           0.0020591900f,
           0.0009798939f,
          -0.0015236388f,
           0.0030685537f,
          -0.0008254433f,
           0.0040196306f,
          -0.0008940736f,
           0.0020380694f
    },
    {
          -0.0029953343f,     /* Filter 12 */
           0.0000315079f,
          -0.0040097613f,
          -0.0018524437f,
          -0.0023423449f,
          -0.0037057392f,
          -0.0006179501f,
          -0.0112258334f,
           0.0050322861f,
          -0.0369815859f,
          -0.0204518607f,
          -0.0371696370f,
          -0.2314700325f,
           0.0000000000f,
           0.2927126894f,
           0.0726598745f,
          -0.0127098581f,
           0.0376724787f,
          -0.0121296126f,
           0.0025866021f,
           0.0009728452f,
          -0.0012707638f,
           0.0030739290f,
          -0.0007113378f,
           0.0040592849f,
          -0.0008619066f,
           0.0021074766f
    },
    {
          -0.0029892802f,     /* Filter 13 */
           0.0000656581f,
          -0.0040481738f,
          -0.0017603822f,
          -0.0024010313f,
          -0.0035530327f,
          -0.0006379263f,
          -0.0110244264f,
           0.0053228127f,
          -0.0372709051f,
          -0.0194372322f,
          -0.0385662576f,
          -0.2344114175f,
           0.0000000000f,
           0.2906284665f,
           0.0711363835f,
          -0.0109719283f,
           0.0379419771f,
          -0.0118461855f,
           0.0031014405f,
           0.0009650237f,
          -0.0010202504f,
           0.0030761174f,
          -0.0005970840f,
           0.0040955442f,
          -0.0008293163f,
           0.0021744821f
    },
    {
          -0.0029805445f,     /* Filter 14 */
           0.0001000532f,
          -0.0040836940f,
          -0.0016664628f,
          -0.0024577161f,
          -0.0033947827f,
          -0.0006576095f,
          -0.0108093037f,
           0.0056151934f,
          -0.0375410830f,
          -0.0183903004f,
          -0.0399730727f,
          -0.2373260846f,
           0.0000000000f,
           0.2884972851f,
           0.0696133632f,
          -0.0092634518f,
           0.0381825282f,
          -0.0115600635f,
           0.0036035431f,
           0.0009564483f,
          -0.0007722959f,
           0.0030751477f,
          -0.0004827837f,
           0.0041284027f,
          -0.0007963345f,
           0.0022390484f
    },
    {
          -0.0029691137f,     /* Filter 15 */
           0.0001346683f,
          -0.0041162709f,
          -0.0015707543f,
          -0.0025123315f,
          -0.0032310628f,
          -0.0006769777f,
          -0.0105804032f,
           0.0059092553f,
          -0.0377916182f,
          -0.0173110425f,
          -0.0413897022f,
          -0.2402130469f,
           0.0000000000f,
           0.2863199341f,
           0.0680912949f,
          -0.0075847116f,
           0.0383945004f,
          -0.0112714793f,
           0.0040927478f,
           0.0009471377f,
          -0.0005270858f,
           0.0030710535f,
          -0.0003685390f,
           0.0041578530f,
          -0.0007629893f,
           0.0023011405f
    },
    {
          -0.0029549761f,     /* Filter 16 */
           0.0001694743f,
          -0.0041458602f,
          -0.0014733283f,
          -0.0025648091f,
          -0.0030619615f,
          -0.0006960095f,
          -0.0103376715f,
           0.0062048215f,
          -0.0380220031f,
          -0.0161994415f,
          -0.0428157525f,
          -0.2430713004f,
           0.0000000000f,
           0.2840972152f,
           0.0665706608f,
          -0.0059359787f,
           0.0385782755f,
          -0.0109806680f,
           0.0045689089f,
           0.0009371115f,
          -0.0002848044f,
           0.0030638693f,
          -0.0002544469f,
           0.0041838948f,
          -0.0007293112f,
           0.0023607247f
    },
    {
          -0.0029381234f,     /* Filter 17 */
           0.0002044455f,
          -0.0041724192f,
          -0.0013742551f,
          -0.0026150829f,
          -0.0028875692f,
          -0.0007146828f,
          -0.0100810704f,
           0.0065017099f,
          -0.0382317485f,
          -0.0150555060f,
          -0.0442508242f,
          -0.2458997907f,
           0.0000000000f,
           0.2818299191f,
           0.0650519389f,
          -0.0043175064f,
           0.0387342290f,
          -0.0106878589f,
           0.0050318997f,
           0.0009263889f,
          -0.0000456328f,
           0.0030536296f,
          -0.0001406071f,
           0.0042065279f,
          -0.0006953299f,
           0.0024177706f
    },
    {
          -0.0029185509f,     /* Filter 18 */
           0.0002395529f,
          -0.0041958991f,
          -0.0012736106f,
          -0.0026630870f,
          -0.0027079834f,
          -0.0007329762f,
          -0.0098105660f,
           0.0067997380f,
          -0.0384203595f,
          -0.0138792561f,
          -0.0456945081f,
          -0.2486975418f,
           0.0000000000f,
           0.2795189375f,
           0.0635356160f,
          -0.0027295403f,
           0.0388627630f,
          -0.0103932783f,
           0.0054815914f,
           0.0009149904f,
           0.0001902551f,
           0.0030403759f,
          -0.0000271166f,
           0.0042257549f,
          -0.0006610751f,
           0.0024722493f
    },
    {
          -0.0028962540f,     /* Filter 19 */
           0.0002747697f,
          -0.0042162668f,
          -0.0011714716f,
          -0.0027087581f,
          -0.0025233048f,
          -0.0007508676f,
          -0.0095261317f,
           0.0070987166f,
          -0.0385873452f,
          -0.0126707281f,
          -0.0471463981f,
          -0.2514635379f,
           0.0000000000f,
           0.2771650518f,
           0.0620221546f,
          -0.0011723105f,
           0.0389642752f,
          -0.0100971511f,
           0.0059178704f,
           0.0009029357f,
           0.0004226896f,
           0.0030241469f,
           0.0000859258f,
           0.0042415846f,
          -0.0006265770f,
           0.0025241333f
    },
    {
          -0.0028712275f,     /* Filter 20 */
           0.0003100667f,
          -0.0042334829f,
          -0.0010679155f,
          -0.0027520330f,
          -0.0023336385f,
          -0.0007683354f,
          -0.0092277581f,
           0.0073984545f,
          -0.0387322185f,
          -0.0114299621f,
          -0.0486060766f,
          -0.2541967944f,
           0.0000000000f,
           0.2747691711f,
           0.0605120265f,
           0.0003539842f,
           0.0390391742f,
          -0.0097997036f,
           0.0063406383f,
           0.0008902450f,
           0.0006515064f,
           0.0030049884f,
           0.0001984275f,
           0.0042540230f,
          -0.0005918659f,
           0.0025734007f
    },
    {
          -0.0028434772f,     /* Filter 21 */
           0.0003454155f,
          -0.0042475118f,
          -0.0009630217f,
          -0.0027928509f,
          -0.0021391009f,
          -0.0007853583f,
          -0.0089154411f,
           0.0076987586f,
          -0.0388545084f,
          -0.0101570232f,
          -0.0500731192f,
          -0.2568963346f,
           0.0000000000f,
           0.2723321314f,
           0.0590057069f,
           0.0018491331f,
           0.0390878840f,
          -0.0095011535f,
           0.0067498038f,
           0.0008769393f,
           0.0008765438f,
           0.0029829434f,
           0.0003102929f,
           0.0042630834f,
          -0.0005569712f,
           0.0026200288f
    },
    {
          -0.0028130005f,     /* Filter 22 */
           0.0003807876f,
          -0.0042583189f,
          -0.0008568735f,
          -0.0028311524f,
          -0.0019398084f,
          -0.0008019140f,
          -0.0085891878f,
           0.0079994291f,
          -0.0389537393f,
          -0.0088519897f,
          -0.0515470994f,
          -0.2595612030f,
           0.0000000000f,
           0.2698548228f,
           0.0575036409f,
           0.0033129675f,
           0.0391108297f,
          -0.0092017204f,
           0.0071452877f,
           0.0008630391f,
           0.0010976484f,
           0.0029580601f,
           0.0004214283f,
           0.0042687793f,
          -0.0005219232f,
           0.0026639994f
    },
    {
          -0.0027798077f,     /* Filter 23 */
           0.0004161537f,
          -0.0042658758f,
          -0.0007495544f,
          -0.0028668803f,
          -0.0017358856f,
          -0.0008179815f,
          -0.0082490135f,
           0.0083002667f,
          -0.0390294419f,
          -0.0075149545f,
          -0.0530275838f,
          -0.2621904272f,
           0.0000000000f,
           0.2673381654f,
           0.0560063002f,
           0.0047453124f,
           0.0391084429f,
          -0.0089016211f,
           0.0075270221f,
           0.0008485652f,
           0.0013146691f,
           0.0029303866f,
           0.0005317429f,
           0.0042711304f,
          -0.0004867513f,
           0.0027052959f
    },
    {
          -0.0027439022f,     /* Filter 24 */
           0.0004514848f,
          -0.0042701555f,
          -0.0006411480f,
          -0.0028999763f,
          -0.0015274614f,
          -0.0008335389f,
          -0.0078949462f,
           0.0086010664f,
          -0.0390811643f,
          -0.0061460197f,
          -0.0545141302f,
          -0.2647830558f,
           0.0000000000f,
           0.2647830558f,
           0.0545141302f,
           0.0061460197f,
           0.0390811643f,
          -0.0086010664f,
           0.0078949462f,
           0.0008335389f,
           0.0015274614f,
           0.0028999763f,
           0.0006411480f,
           0.0042701555f,
          -0.0004514848f,
           0.0027439022f
    },
    {
          -0.0027052959f,     /* Filter 25 */
           0.0004867513f,
          -0.0042711304f,
          -0.0005317429f,
          -0.0029303866f,
          -0.0013146691f,
          -0.0008485652f,
          -0.0075270221f,
           0.0089016211f,
          -0.0391084429f,
          -0.0047453124f,
          -0.0560063002f,
          -0.2673381655f,
           0.0000000000f,
           0.2621904272f,
           0.0530275838f,
           0.0075149545f,
           0.0390294419f,
          -0.0083002667f,
           0.0082490135f,
           0.0008179814f,
           0.0017358856f,
           0.0028668803f,
           0.0007495544f,
           0.0042658758f,
          -0.0004161537f,
           0.0027798077f
    },
    {
          -0.0026639994f,     /* Filter 26 */
           0.0005219232f,
          -0.0042687793f,
          -0.0004214283f,
          -0.0029580601f,
          -0.0010976484f,
          -0.0008630391f,
          -0.0071452877f,
           0.0092017204f,
          -0.0391108297f,
          -0.0033129675f,
          -0.0575036410f,
          -0.2698548228f,
           0.0000000000f,
           0.2595612030f,
           0.0515470994f,
           0.0088519897f,
           0.0389537393f,
          -0.0079994291f,
           0.0085891878f,
           0.0008019140f,
           0.0019398084f,
           0.0028311524f,
           0.0008568735f,
           0.0042583189f,
          -0.0003807876f,
           0.0028130005f
    },
    {
          -0.0026200288f,     /* Filter 27 */
           0.0005569712f,
          -0.0042630834f,
          -0.0003102929f,
          -0.0029829434f,
          -0.0008765438f,
          -0.0008769393f,
          -0.0067498036f,
           0.0095011535f,
          -0.0390878840f,
          -0.0018491331f,
          -0.0590057069f,
          -0.2723321315f,
           0.0000000000f,
           0.2568963346f,
           0.0500731192f,
           0.0101570232f,
           0.0388545084f,
          -0.0076987586f,
           0.0089154411f,
           0.0007853583f,
           0.0021391009f,
           0.0027928509f,
           0.0009630217f,
           0.0042475118f,
          -0.0003454155f,
           0.0028434772f
    },
    {
          -0.0025734007f,     /* Filter 28 */
           0.0005918659f,
          -0.0042540230f,
          -0.0001984275f,
          -0.0030049884f,
          -0.0006515064f,
          -0.0008902450f,
          -0.0063406383f,
           0.0097997036f,
          -0.0390391742f,
          -0.0003539842f,
          -0.0605120265f,
          -0.2747691711f,
           0.0000000000f,
           0.2541967944f,
           0.0486060766f,
           0.0114299621f,
           0.0387322185f,
          -0.0073984545f,
           0.0092277581f,
           0.0007683354f,
           0.0023336385f,
           0.0027520330f,
           0.0010679155f,
           0.0042334829f,
          -0.0003100667f,
           0.0028712275f
    },
    {
          -0.0025241333f,     /* Filter 29 */
           0.0006265770f,
          -0.0042415846f,
          -0.0000859258f,
          -0.0030241469f,
          -0.0004226896f,
          -0.0009029357f,
          -0.0059178704f,
           0.0100971511f,
          -0.0389642752f,
           0.0011723105f,
          -0.0620221546f,
          -0.2771650518f,
           0.0000000000f,
           0.2514635379f,
           0.0471463981f,
           0.0126707281f,
           0.0385873452f,
          -0.0070987166f,
           0.0095261317f,
           0.0007508676f,
           0.0025233048f,
           0.0027087581f,
           0.0011714716f,
           0.0042162668f,
          -0.0002747697f,
           0.0028962540f
    },
    {
          -0.0024722493f,     /* Filter 30 */
           0.0006610751f,
          -0.0042257549f,
           0.0000271166f,
          -0.0030403759f,
          -0.0001902551f,
          -0.0009149904f,
          -0.0054815914f,
           0.0103932783f,
          -0.0388627629f,
           0.0027295403f,
          -0.0635356160f,
          -0.2795189375f,
           0.0000000000f,
           0.2486975418f,
           0.0456945081f,
           0.0138792561f,
           0.0384203595f,
          -0.0067997380f,
           0.0098105660f,
           0.0007329762f,
           0.0027079834f,
           0.0026630870f,
           0.0012736106f,
           0.0041958991f,
          -0.0002395529f,
           0.0029185509f
    },
    {
          -0.0024177706f,     /* Filter 31 */
           0.0006953299f,
          -0.0042065279f,
           0.0001406071f,
          -0.0030536296f,
           0.0000456328f,
          -0.0009263889f,
          -0.0050318997f,
           0.0106878589f,
          -0.0387342290f,
           0.0043175064f,
          -0.0650519389f,
          -0.2818299191f,
           0.0000000000f,
           0.2458997907f,
           0.0442508242f,
           0.0150555060f,
           0.0382317485f,
          -0.0065017099f,
           0.0100810704f,
           0.0007146828f,
           0.0028875692f,
           0.0026150829f,
           0.0013742551f,
           0.0041724192f,
          -0.0002044455f,
           0.0029381234f
    },
    {
          -0.0023607247f,     /* Filter 32 */
           0.0007293112f,
          -0.0041838948f,
           0.0002544469f,
          -0.0030638693f,
           0.0002848044f,
          -0.0009371115f,
          -0.0045689089f,
           0.0109806680f,
          -0.0385782755f,
           0.0059359787f,
          -0.0665706608f,
          -0.2840972153f,
           0.0000000000f,
           0.2430713004f,
           0.0428157525f,
           0.0161994415f,
           0.0380220031f,
          -0.0062048215f,
           0.0103376715f,
           0.0006960095f,
           0.0030619615f,
           0.0025648091f,
           0.0014733283f,
           0.0041458602f,
          -0.0001694743f,
           0.0029549761f
    },
    {
          -0.0023011405f,     /* Filter 33 */
           0.0007629893f,
          -0.0041578530f,
           0.0003685390f,
          -0.0030710535f,
           0.0005270858f,
          -0.0009471377f,
          -0.0040927478f,
           0.0112714793f,
          -0.0383945003f,
           0.0075847116f,
          -0.0680912949f,
          -0.2863199341f,
           0.0000000000f,
           0.2402130469f,
           0.0413897022f,
           0.0173110426f,
           0.0377916182f,
          -0.0059092553f,
           0.0105804032f,
           0.0006769777f,
           0.0032310628f,
           0.0025123315f,
           0.0015707543f,
           0.0041162709f,
          -0.0001346683f,
           0.0029691137f
    },
    {
          -0.0022390484f,     /* Filter 34 */
           0.0007963345f,
          -0.0041284027f,
           0.0004827837f,
          -0.0030751477f,
           0.0007722959f,
          -0.0009564483f,
          -0.0036035431f,
           0.0115600635f,
          -0.0381825282f,
           0.0092634518f,
          -0.0696133632f,
          -0.2884972852f,
           0.0000000000f,
           0.2373260846f,
           0.0399730727f,
           0.0183903004f,
           0.0375410830f,
          -0.0056151934f,
           0.0108093037f,
           0.0006576095f,
           0.0033947827f,
           0.0024577161f,
           0.0016664628f,
           0.0040836940f,
          -0.0001000532f,
           0.0029805445f
    },
    {
          -0.0021744821f,     /* Filter 35 */
           0.0008293163f,
          -0.0040955442f,
           0.0005970840f,
          -0.0030761174f,
           0.0010202504f,
          -0.0009650237f,
          -0.0031014405f,
           0.0118461855f,
          -0.0379419771f,
           0.0109719284f,
          -0.0711363835f,
          -0.2906284665f,
           0.0000000000f,
           0.2344114175f,
           0.0385662576f,
           0.0194372322f,
           0.0372709051f,
          -0.0053228127f,
           0.0110244264f,
           0.0006379263f,
           0.0035530327f,
           0.0024010313f,
           0.0017603822f,
           0.0040481738f,
          -0.0000656581f,
           0.0029892802f
    },
    {
          -0.0021074766f,     /* Filter 36 */
           0.0008619066f,
          -0.0040592849f,
           0.0007113378f,
          -0.0030739290f,
           0.0012707638f,
          -0.0009728452f,
          -0.0025866021f,
           0.0121296126f,
          -0.0376724787f,
           0.0127098581f,
          -0.0726598745f,
          -0.2927126894f,
           0.0000000000f,
           0.2314700325f,
           0.0371696370f,
           0.0204518608f,
           0.0369815859f,
          -0.0050322861f,
           0.0112258334f,
           0.0006179501f,
           0.0037057392f,
           0.0023423449f,
           0.0018524437f,
           0.0040097613f,
          -0.0000315079f,
           0.0029953343f
    },
    {
          -0.0020380694f,     /* Filter 37 */
           0.0008940736f,
          -0.0040196306f,
           0.0008254433f,
          -0.0030685537f,
           0.0015236388f,
          -0.0009798939f,
          -0.0020591900f,
           0.0124101104f,
          -0.0373736831f,
           0.0144769324f,
          -0.0741833414f,
          -0.2947492090f,
           0.0000000000f,
           0.2285030143f,
           0.0357835947f,
           0.0214342183f,
           0.0366736316f,
          -0.0047437837f,
           0.0114135888f,
           0.0005977024f,
           0.0038528212f,
           0.0022817271f,
           0.0019425826f,
           0.0039685085f,
           0.0000023707f,
           0.0029987207f
    },
    {
          -0.0019663015f,     /* Filter 38 */
           0.0009257899f,
          -0.0039765949f,
           0.0009392972f,
          -0.0030599648f,
           0.0017786820f,
          -0.0009861512f,
          -0.0015193877f,
           0.0126874405f,
          -0.0370452384f,
           0.0162728428f,
          -0.0757062934f,
          -0.2967372670f,
           0.0000000000f,
           0.2255113940f,
           0.0344085026f,
           0.0223843650f,
           0.0363475566f,
          -0.0044574722f,
           0.0115877798f,
           0.0005772045f,
           0.0039942164f,
           0.0022192491f,
           0.0020307330f,
           0.0039244652f,
           0.0000359510f,
           0.0029994575f
    },
    {
          -0.0018922157f,     /* Filter 39 */
           0.0009570246f,
          -0.0039301906f,
           0.0010527980f,
          -0.0030481364f,
           0.0020356887f,
          -0.0009915996f,
          -0.0009673802f,
           0.0129613633f,
          -0.0366868117f,
           0.0180972548f,
          -0.0772282452f,
          -0.2986760977f,
           0.0000000000f,
           0.2224962126f,
           0.0330447295f,
           0.0233023615f,
           0.0360038798f,
          -0.0041735128f,
           0.0117484865f,
           0.0005564782f,
           0.0041298574f,
           0.0021549819f,
           0.0021168342f,
           0.0038776870f,
           0.0000692078f,
           0.0029975637f
    },
    {
          -0.0018158530f,     /* Filter 40 */
           0.0009877493f,
          -0.0038804334f,
           0.0011658419f,
          -0.0030330480f,
           0.0022944544f,
          -0.0009962207f,
          -0.0004033739f,
           0.0132316390f,
          -0.0362980733f,
           0.0199498223f,
          -0.0787486942f,
          -0.3005650049f,
           0.0000000000f,
           0.2194585217f,
           0.0316926279f,
           0.0241882873f,
           0.0356431071f,
          -0.0038920642f,
           0.0118958109f,
           0.0005355448f,
           0.0042596878f,
           0.0020889998f,
           0.0022008259f,
           0.0038282335f,
           0.0001021172f,
           0.0029930609f
    },
    {
          -0.0017372664f,     /* Filter 41 */
           0.0010179362f,
          -0.0038273449f,
           0.0012783271f,
          -0.0030146768f,
           0.0025547698f,
          -0.0009999976f,
           0.0001724233f,
           0.0134980262f,
          -0.0358787092f,
           0.0218301877f,
          -0.0802671405f,
          -0.3024033068f,
           0.0000000000f,
           0.2163993844f,
           0.0303525561f,
           0.0250422344f,
           0.0352657604f,
          -0.0036132805f,
           0.0120298496f,
           0.0005144257f,
           0.0043836566f,
           0.0020213751f,
           0.0022826512f,
           0.0037761582f,
           0.0001346534f,
           0.0029859721f
    },
    {
          -0.0016564989f,     /* Filter 42 */
           0.0010475555f,
          -0.0037709467f,
           0.0013901463f,
          -0.0029930087f,
           0.0028164188f,
          -0.0010029139f,
           0.0007597857f,
           0.0137602804f,
          -0.0354284196f,
           0.0237379776f,
          -0.0817830924f,
          -0.3041903010f,
           0.0000000000f,
           0.2133198677f,
           0.0290248545f,
           0.0258643154f,
           0.0348723629f,
          -0.0033373122f,
           0.0121507178f,
           0.0004931418f,
           0.0045017152f,
           0.0019521811f,
           0.0023622545f,
           0.0037215252f,
           0.0001667922f,
           0.0029763241f
    },
    {
          -0.0015736058f,     /* Filter 43 */
           0.0010765785f,
          -0.0037112660f,
           0.0015011959f,
          -0.0029680271f,
           0.0030791857f,
          -0.0010049524f,
           0.0013584756f,
           0.0140181582f,
          -0.0349469084f,
           0.0256728037f,
          -0.0832960468f,
          -0.3059253229f,
           0.0000000000f,
           0.2102210189f,
           0.0277098630f,
           0.0266546448f,
           0.0344634328f,
          -0.0030643056f,
           0.0122585417f,
           0.0004717142f,
           0.0046138230f,
           0.0018814932f,
           0.0024395825f,
           0.0036643951f,
           0.0001985113f,
           0.0029641442f
    },
    {
          -0.0014886367f,     /* Filter 44 */
           0.0011049782f,
          -0.0036483309f,
           0.0016113720f,
          -0.0029397209f,
           0.0033428487f,
          -0.0010060975f,
           0.0019682529f,
           0.0142714155f,
          -0.0344338896f,
           0.0276342580f,
          -0.0848055039f,
          -0.3076077361f,
           0.0000000000f,
           0.2071039176f,
           0.0264079117f,
           0.0274133503f,
           0.0340394978f,
          -0.0027944026f,
           0.0123534430f,
           0.0004501638f,
           0.0047199445f,
           0.0018093883f,
           0.0025145856f,
           0.0036048329f,
           0.0002297865f,
           0.0029494611f
    },
    {
          -0.0014016500f,     /* Filter 45 */
           0.0011327259f,
          -0.0035821731f,
           0.0017205660f,
          -0.0029080816f,
           0.0036071832f,
          -0.0010063334f,
           0.0025888544f,
           0.0145198058f,
          -0.0338891017f,
           0.0296219304f,
          -0.0863109612f,
          -0.3092369205f,
           0.0000000000f,
           0.2039696262f,
           0.0251193187f,
           0.0281405891f,
           0.0336010744f,
          -0.0025277420f,
           0.0124355589f,
           0.0004285111f,
           0.0048200496f,
           0.0017359407f,
           0.0025872148f,
           0.0035429020f,
           0.0002605962f,
           0.0029323077f
    },
    {
          -0.0013127044f,     /* Filter 46 */
           0.0011597951f,
          -0.0035128275f,
           0.0018286776f,
          -0.0028731019f,
           0.0038719586f,
          -0.0010056449f,
           0.0032200133f,
           0.0147630810f,
          -0.0333122836f,
           0.0316353806f,
          -0.0878119126f,
          -0.3108122511f,
           0.0000000000f,
           0.2008192272f,
           0.0238444047f,
           0.0288365110f,
           0.0331486948f,
          -0.0022644566f,
           0.0125050331f,
           0.0004067766f,
           0.0049141135f,
           0.0016612271f,
           0.0026574255f,
           0.0034786678f,
           0.0002909172f,
           0.0029127149f
    },
    {
          -0.0012218546f,     /* Filter 47 */
           0.0011861593f,
          -0.0034403309f,
           0.0019355976f,
          -0.0028347787f,
           0.0041369471f,
          -0.0010040176f,
           0.0038614490f,
           0.0150009950f,
          -0.0327031863f,
           0.0336741686f,
          -0.0893078595f,
          -0.3123331621f,
           0.0000000000f,
           0.1976537959f,
           0.0225834661f,
           0.0295012876f,
           0.0326828808f,
          -0.0020046772f,
           0.0125620192f,
           0.0003849809f,
           0.0050021163f,
           0.0015853246f,
           0.0027251726f,
           0.0034122025f,
           0.0003207295f,
           0.0028907191f
    }
};
