/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __OPENMRCP_CLIENT_H__
#define __OPENMRCP_CLIENT_H__

/**
 * @file openmrcp_client.h
 * @brief OpenMRCP Client (user level interface).
 */ 

#include <apr_network_io.h>
#include "apt_string_table.h"
#include "mrcp_client.h"


MRCP_BEGIN_EXTERN_C

typedef struct openmrcp_client_options_t openmrcp_client_options_t;
/** OpenMRCP client configuration */
struct openmrcp_client_options_t {
	/* base object */
	mrcp_client_module_loader_t    module_loader;

	mrcp_version_t                 proto_version;

	char                          *client_ip;
	apr_port_t                     client_port;
	
	char                          *server_ip;
	apr_port_t                     server_port;

	apr_port_t                     rtp_port_min;
	apr_port_t                     rtp_port_max;

	char                          *resource_location;
	const apt_string_table_item_t *resource_string_table;
};

/** 
 * Create the default options for client.
 * @param pool the pool to allocate memory from
 * @return the created options instance
 */
openmrcp_client_options_t* openmrcp_client_options_create(apr_pool_t *pool);


/** 
 * Start MRCP client with predefined modules.
 * @param options the configuration of OpenMRCP client
 * @param client_context the context attached to client
 * @return the created client instance
 */
mrcp_client_t* openmrcp_client_start(openmrcp_client_options_t *options, mrcp_client_context_t *client_context);

/** 
 * Shutdown MRCP client.
 * @param mrcp_client the MRCP client to shutdown
 */
mrcp_status_t openmrcp_client_shutdown(mrcp_client_t *mrcp_client);


MRCP_END_EXTERN_C

#endif /*__OPENMRCP_CLIENT_H__*/
