/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "mrcp_server_signaling_agent.h"

mrcp_signaling_agent_t* mrcp_server_signaling_agent_create(
								const mrcp_module_method_set_t *method_set,
								void *object,
								apr_pool_t *pool)
{
	mrcp_signaling_agent_t* agent = apr_palloc(pool,sizeof(mrcp_signaling_agent_t));
	agent->object = object;

	mrcp_module_init(&agent->module,method_set);

	mrcp_descriptor_init(&agent->capabilities);
	agent->sip_port = 0;
	agent->mrcp_port = 0;
	agent->sip_contact_str = NULL;
	agent->resource_location = NULL;

	return agent;
}

mrcp_signaling_channel_t* mrcp_server_signaling_channel_create(
									mrcp_signaling_agent_t *agent,
									const mrcp_signaling_channel_method_set_t *method_set,
									void *object,
									apr_pool_t *pool)
{
	mrcp_signaling_channel_t* channel = apr_palloc(pool,sizeof(mrcp_signaling_channel_t));
	channel->method_set = method_set;
	channel->event_set = agent->channel_event_set;
	channel->object = object;

	channel->agent = agent;
	channel->session = NULL;
	channel->pool = pool;

	mrcp_descriptor_init(&channel->local_descriptor);
	mrcp_descriptor_init(&channel->remote_descriptor);

	channel->local_descriptor.ip = agent->capabilities.ip;
	return channel;
}
