/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_SERVER_H__
#define __MRCP_SERVER_H__

/**
 * @file mrcp_server.h
 * @brief MRCP Server Engine Definition.
 */ 

#include "mrcp_server_types.h"
#include "mrcp_server_resource.h"

MRCP_BEGIN_EXTERN_C


typedef struct mrcp_server_module_loader_t mrcp_server_module_loader_t;
/** Module loader of MRCP server */
struct mrcp_server_module_loader_t {
	/** Create signaling agent */
	mrcp_signaling_agent_t* (*signaling_agent_create)(mrcp_server_module_loader_t *module_loader, apr_pool_t *pool);
	/** Create MRCP protocol agent */
	mrcp_proto_agent_t* (*proto_agent_create)(mrcp_server_module_loader_t *module_loader, mrcp_signaling_agent_t* signaling_agent, apr_pool_t *pool);
	/** Create media agent */
	mrcp_media_agent_t* (*media_agent_create)(mrcp_server_module_loader_t *module_loader, apr_pool_t *pool);
	/** Create container of MRCP resources */
	mrcp_resource_container_t* (*resource_container_create)(mrcp_server_module_loader_t *module_loader, apr_pool_t *pool);
};

/** 
 * Create MRCP server instance and start message processing loop.
 * @param module_loader the module loader passed to created server instance
 * @return the created server instance
 */
mrcp_server_t* mrcp_server_start(mrcp_server_module_loader_t *module_loader);
/** 
 * Shutdown message processing loop and destroy MRCP server.
 * @param mrcp_server the MRCP server to shutdown
 */
mrcp_status_t mrcp_server_shutdown(mrcp_server_t* mrcp_server);


MRCP_END_EXTERN_C

#endif /*__MRCP_SERVER_H__*/
