/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_RESOURCE_SET_H__
#define __MRCP_RESOURCE_SET_H__

/**
 * @file mrcp_resource_set.h
 * @brief Set of MRCP Resources
 */ 

#include "mrcp.h"

MRCP_BEGIN_EXTERN_C

/** Enumaration of available MRCP resources */
typedef enum {
	/** Synthesizer resource */
	MRCP_RESOURCE_SYNTHESIZER,
	/** Recognizer resource */
	MRCP_RESOURCE_RECOGNIZER,

	/** Number of resources */
	MRCP_RESOURCE_COUNT
} mrcp_resource_set_t;


MRCP_END_EXTERN_C

#endif /*__MRCP_RESOURCE_SET_H__*/
