/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_CLIENT_TYPES_H__
#define __MRCP_CLIENT_TYPES_H__

/**
 * @file mrcp_client_types.h
 * @brief MRCP Client Type Declarations
 */ 

#include "mrcp_types.h"

MRCP_BEGIN_EXTERN_C

/** Opaque MRCP client declaration. */
typedef struct mrcp_client_t mrcp_client_t;

/** Opaque MRCP client resource declaration. */
typedef struct mrcp_client_resource_t mrcp_client_resource_t;

/** Opaque MRCP client resource container declaration. */
typedef struct mrcp_client_resource_container_t mrcp_client_resource_container_t;

/** Opaque MRCP client resource channel declaration. */
typedef struct mrcp_client_channel_t mrcp_client_channel_t;

/** Opaque MRCP client context declaration. */
typedef struct mrcp_client_context_t mrcp_client_context_t;

/** Opaque MRCP client module declaration. */
typedef struct mrcp_client_module_loader_t mrcp_client_module_loader_t;

/** Opaque MRCP client event handler declaration. */
typedef struct mrcp_client_event_handler_t mrcp_client_event_handler_t;

MRCP_END_EXTERN_C

#endif /*__MRCP_CLIENT_TYPES_H__*/
