/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_ENGINE_H__
#define __MRCP_ENGINE_H__

/**
 * @file mrcp_engine.h
 * @brief MRCP Engine Definition.
 */ 

#include "mrcp_types.h"
#include "mrcp_module.h"
#include "apt_consumer_task.h"

MRCP_BEGIN_EXTERN_C

#define MRCP_MAX_MODULE_COUNT 20

/** Engine is an abstract base of client and server. */
struct mrcp_engine_t {
	/** Array of registered modules */
	mrcp_module_t       *modules[MRCP_MAX_MODULE_COUNT];
	/** Number of registered modules */
	size_t               module_count;

	/** Main task waiting for incoming messages */
	apt_consumer_task_t *consumer_task;
};

/** 
 * Init MRCP engine.
 * @param engine the engine to initialize
 */
mrcp_status_t mrcp_engine_init(mrcp_engine_t *engine);

/** 
 * Destroy MRCP engine.
 * @param engine the engine to destroy
 */
mrcp_status_t mrcp_engine_destroy(mrcp_engine_t *engine);

/** 
 * Register MRCP module.
 * @param engine the engine to register module to
 * @param module the module to register
 */
mrcp_status_t mrcp_engine_module_register(mrcp_engine_t *engine, mrcp_module_t *module);

/** 
 * Open MRCP engine.
 * @param engine the engine to open
 */
mrcp_module_state_t mrcp_engine_open(mrcp_engine_t *engine);

/** 
 * Close MRCP engine.
 * @param engine the engine to close
 */
mrcp_module_state_t mrcp_engine_close(mrcp_engine_t *engine);

/** 
 * Query whether engine is closed.
 * @param engine the engine to query
 */
mrcp_status_t mrcp_engine_is_closed(mrcp_engine_t *engine);


MRCP_END_EXTERN_C

#endif /*__MRCP_SERVER_H__*/
