/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MEDIA_TIMER_H__
#define __MEDIA_TIMER_H__

/**
 * @file media_timer.h
 * @brief Media Timer Interface
 */ 

#include <apr_pools.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Opaque media timer declaration */
typedef struct media_timer_t media_timer_t;

/** Prototype of media timer callback */
typedef void (*media_timer_proc)(media_timer_t *timer, void *data);

/** Start periodic media timer */
media_timer_t* media_timer_start(unsigned long timeout, media_timer_proc timer_proc, void *data, apr_pool_t *pool);

/** Stop media timer */
void media_timer_stop(media_timer_t *timer);

#ifdef __cplusplus
}
#endif

#endif /*__MEDIA_TIMER_H__*/
