/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MEDIA_CONTEXT_H__
#define __MEDIA_CONTEXT_H__

/**
 * @file media_context.h
 * @brief Media Context
 */ 

#include "media_types.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct media_context_method_set_t media_context_method_set_t;
/** Media context */
struct media_context_t {
	const media_context_method_set_t *method_set;
	apr_pool_t                       *pool;

	media_context_t                  *next;
	media_context_t                  *prev;
};

/** Set of media context virtual methods */
struct media_context_method_set_t {
	apr_status_t (*destroy)(media_context_t *context);

	apr_status_t (*audio_source_add)(media_context_t *context, audio_source_t *source);
	apr_status_t (*audio_source_remove)(media_context_t *context, audio_source_t *source);

	apr_status_t (*audio_sink_add)(media_context_t *context, audio_sink_t *sink);
	apr_status_t (*audio_sink_remove)(media_context_t *context, audio_sink_t *sink);

	apr_status_t (*process)(media_context_t *context);
};

/** Initialize media context */
static APR_INLINE void media_context_init(media_context_t *context, apr_pool_t *pool)
{
	context->pool = pool;
	context->next = context->prev = NULL;
}

#ifdef __cplusplus
}
#endif

#endif /*__MEDIA_CONTEXT_H__*/
