/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __JITTER_BUFFER_H__
#define __JITTER_BUFFER_H__

/**
 * @file jitter_buffer.h
 * @brief Jitter Buffer
 */ 

#include <apr_pools.h>
#include "media_frame.h"
#include "codec_manipulator.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Jitter buffer write result */
typedef enum {
	JB_OK,
	JB_DISCARD_NOT_ALLIGNED,
	JB_DISCARD_TOO_LATE,
	JB_DISCARD_TOO_EARLY,
} jb_result_t;

typedef struct jitter_buffer_config_t jitter_buffer_config_t;

/** Jitter buffer configuration */
struct jitter_buffer_config_t {
	apr_size_t min_playout_delay;
	apr_size_t initial_playout_delay;
	apr_size_t max_playout_delay;
	apr_byte_t adaptive;
};

typedef struct jitter_buffer_t jitter_buffer_t;

/** Create jitter buffer */
jitter_buffer_t* jitter_buffer_create(jitter_buffer_config_t *jb_config, apr_size_t sampling_rate, apr_pool_t *pool);

/** Destroy jitter buffer */
apr_status_t jitter_buffer_destroy(jitter_buffer_t *jb);

/** Restart jitter buffer */
apr_status_t jitter_buffer_restart(jitter_buffer_t *jb);

/** Write audio data to jitter buffer */
jb_result_t jitter_buffer_write(jitter_buffer_t *jb, codec_handle_t *codec, void *buffer, apr_size_t size, apr_uint32_t ts);

/** Write named event to jitter buffer */
jb_result_t jitter_buffer_write_named_event(jitter_buffer_t *jb, named_event_frame_t *named_event, apr_uint32_t ts);

/** Read media frame from jitter buffer */
apr_status_t jitter_buffer_read(jitter_buffer_t *jb, media_frame_t *media_frame);

#ifdef __cplusplus
}
#endif

#endif /*__JITTER_BUFFER_H__*/
