/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __CODEC_MANIPULATOR_H__
#define __CODEC_MANIPULATOR_H__

/**
 * @file codec_manipulator.h
 * @brief Codec Manipulator Definition
 */ 

#include "codec_descriptor.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct codec_manipulator_t codec_manipulator_t;
typedef struct codec_handle_t codec_handle_t;

/** Codec handle */
struct codec_handle_t {
	const codec_descriptor_t  *descriptor;
	const codec_manipulator_t *manipulator;

	apr_size_t                 frame_size;

	void                      *object;
};

/** Codec manipulator interface */
struct codec_manipulator_t {
	apr_status_t (*open)(codec_handle_t *handle);
	apr_status_t (*close)(codec_handle_t *handle);

	apr_status_t (*encode)(codec_handle_t *handle, const codec_frame_t *frame_in, codec_frame_t *frame_out);
	apr_status_t (*decode)(codec_handle_t *handle, const codec_frame_t *frame_in, codec_frame_t *frame_out);

	apr_size_t (*dissect)(codec_handle_t *handle, void *buffer, apr_size_t size, codec_frame_t *frames, apr_size_t max_frames);
};


#ifdef __cplusplus
}
#endif

#endif /*__CODEC_MANIPULATOR_H__*/
