/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __CODEC_MANAGER_H__
#define __CODEC_MANAGER_H__

/**
 * @file codec_manager.h
 * @brief Codec Manager Definition
 */ 

#include "media_types.h"
#include "codec_manipulator.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Create codec manager */
codec_manager_t* codec_manager_create(apr_pool_t *pool);

/** Destroy codec manager */
void codec_manager_destroy(codec_manager_t *codec_manager);

/** Register codec in codec manager */
apr_status_t codec_manager_codec_register(codec_manager_t *codec_manager, codec_descriptor_t *descriptor, codec_manipulator_t *manipulator);

/** Get codec manipulator by codec descriptor */
const codec_manipulator_t* codec_manager_codec_get(codec_manager_t *codec_manager, codec_descriptor_t *descriptor);

/** Get list of available codecs */
apr_size_t codec_manager_codec_list_get(codec_manager_t *codec_manager, codec_descriptor_t **codec_list, apr_size_t max_count, apr_pool_t *pool);

#ifdef __cplusplus
}
#endif

#endif /*__CODEC_MANIPULATOR_H__*/
