/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __AUDIO_SOURCE_H__
#define __AUDIO_SOURCE_H__

/**
 * @file audio_source.h
 * @brief Audio Source Definition
 */ 

#include "media_types.h"
#include "media_frame.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct audio_source_method_set_t audio_source_method_set_t;

/** Audio source interface */
struct audio_source_t {
	/** Set of virtual methdos */
	const audio_source_method_set_t *method_set;

	/** Actual object */
	void *object;
};


/** Set of audio source virtual methods */
struct audio_source_method_set_t {
	apr_status_t (*destroy)(audio_source_t *source);

	apr_status_t (*open)(audio_source_t *source);
	apr_status_t (*close)(audio_source_t *source);

	apr_status_t (*read_frame)(audio_source_t *source, media_frame_t *frame);
};


#ifdef __cplusplus
}
#endif

#endif /*__AUDIO_SOURCE_H__*/
