/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_SERVER_PLUGIN_H__
#define __MRCP_SERVER_PLUGIN_H__

/**
 * @file mrcp_server_plugin.h
 * @brief MRCP Server Plugin Definition.
 */ 

#include "mrcp_server_types.h"
#include "mrcp_message.h"
#include "mrcp_module.h"
#include "audio_source.h"
#include "audio_sink.h"

MRCP_BEGIN_EXTERN_C

#ifdef _WIN32
#define MRCP_PLUGIN_DECLARE(type) __declspec(dllexport) type
#else
#define MRCP_PLUGIN_DECLARE(type) type
#endif


/** Prototype of plugin to MRCP method */
typedef mrcp_status_t (*mrcp_server_method_plugin_t)(mrcp_server_channel_t *channel, mrcp_message_t *request_message, mrcp_message_t *response_message);

typedef struct mrcp_server_plugin_t mrcp_server_plugin_t;
/** MRCP server plugin */
struct mrcp_server_plugin_t {
	/** Base module */
	mrcp_module_t                module;

	/** Open channel event handler */
	mrcp_status_t (*channel_open)(mrcp_server_plugin_t *server_plugin, mrcp_server_channel_t *channel, apr_pool_t *pool);
	/** Close channel event handler */
	mrcp_status_t (*channel_close)(mrcp_server_plugin_t *server_plugin, mrcp_server_channel_t *channel);

	/** Registered plugins to MRCP methods */
	mrcp_server_method_plugin_t *method_plugin_array;
	/** Number of registered plugins */
	size_t                       method_count;

	/** Task message pool */
	apt_task_msg_pool_t         *msg_pool;
};

/** Prototype of plugin creator (start point for each pluggable module)*/
typedef mrcp_server_plugin_t* (*mrcp_plugin_creator)(apr_pool_t *pool);

typedef struct mrcp_server_plugin_msg_t mrcp_server_plugin_msg_t;
/** MRCP server plugin message */
struct mrcp_server_plugin_msg_t {
	mrcp_server_channel_t       *channel;
	mrcp_message_t              *mrcp_message;
};

/** Set opaque handle to MRCP channel */
void mrcp_server_channel_handle_set(mrcp_server_channel_t *channel, void *handle);

/** Get opaque handle from MRCP channel */
void* mrcp_server_channel_handle_get(mrcp_server_channel_t *channel);

/** Set audio source to MRCP channel */
void mrcp_server_channel_audio_source_set(mrcp_server_channel_t *channel, audio_source_t* audio_source);

/** Get audio source from MRCP channel */
audio_source_t* mrcp_server_channel_audio_source_get(mrcp_server_channel_t *channel);

/** Set audio sink to MRCP channel */
void mrcp_server_channel_audio_sink_set(mrcp_server_channel_t *channel, audio_sink_t* audio_sink);

/** Get audio sink from MRCP channel */
audio_sink_t* mrcp_server_channel_audio_sink_get(mrcp_server_channel_t *channel);

/** Signal task message */
mrcp_status_t mrcp_server_channel_signal(mrcp_server_channel_t *channel, mrcp_message_t *message);

MRCP_END_EXTERN_C

#endif /*__MRCP_SERVER_PLUGIN_H__*/
