/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "mrcp_resource.h"
#include "mrcp_generic_header.h"

/* creates mrcp resource container */
mrcp_resource_container_t* mrcp_resource_container_create(size_t resource_count, const apt_string_table_item_t *resource_string_table, apr_pool_t *pool)
{
	size_t i;
	mrcp_resource_container_t *resource_container;
	if(resource_count == 0) {
		return NULL;
	}

	resource_container = apr_palloc(pool,sizeof(mrcp_resource_container_t));
	resource_container->resource_count = resource_count;
	resource_container->resource_array = apr_palloc(pool,sizeof(mrcp_resource_t*)*resource_count);

	for(i=0; i<resource_count; i++) {
		resource_container->resource_array[i] = NULL;
	}
	
	resource_container->resource_string_table = resource_string_table;

	mrcp_generic_header_accessor_init(&resource_container->generic_header_accessor);
	return resource_container;
}

/* destroys mrcp resource container */
mrcp_status_t mrcp_resource_container_destroy(mrcp_resource_container_t *resource_container)
{
	if(resource_container->resource_array) {
		resource_container->resource_array = NULL;
	}
	resource_container->resource_count = 0;

	mrcp_generic_header_accessor_destroy(&resource_container->generic_header_accessor);
	return MRCP_STATUS_SUCCESS;
}

/* registers mrcp resource */
mrcp_status_t mrcp_resource_register(mrcp_resource_container_t *resource_container, mrcp_resource_t *resource)
{
	if(!resource) {
		return MRCP_STATUS_FAILURE;
	}
	if(resource->id >= resource_container->resource_count) {
		return MRCP_STATUS_FAILURE;
	}
	if(resource_container->resource_array[resource->id]) {
		return MRCP_STATUS_FAILURE;
	}
	resource->name = mrcp_resource_name_get(resource_container,resource->id);
	resource->generic_header_accessor = &resource_container->generic_header_accessor;
	if(mrcp_resource_validate(resource) != MRCP_STATUS_SUCCESS) {
		return MRCP_STATUS_FAILURE;
	}
	resource_container->resource_array[resource->id] = resource;
	return MRCP_STATUS_SUCCESS;
}
