/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_PARSER_H__
#define __MRCP_PARSER_H__

/**
 * @file mrcp_parser.h
 * @brief MRCP Parser
 */ 

#include "mrcp_message.h"

MRCP_BEGIN_EXTERN_C

#define MRCP_MESSAGE_MAX_SIZE 2048

/** Parse MRCP message */
mrcp_status_t mrcp_message_parse(mrcp_resource_container_t *resource_container, mrcp_message_t *message, apt_text_stream_t *text_stream);

/** Generate MRCP message */
mrcp_status_t mrcp_message_generate(mrcp_resource_container_t *resource_container, mrcp_message_t *message, apt_text_stream_t *text_stream);


/** Associate MRCP resource specific data by resource identifier (mrcp_message->resource_id must be set prior to call of the function) */
mrcp_status_t mrcp_message_associate_resource_by_id(mrcp_resource_container_t *resource_container, mrcp_message_t *message);

/** Associate MRCP resource specific data by resource name (mrcp_message->resource_name must be set prior to call of the function) */
mrcp_status_t mrcp_message_associate_resource_by_name(mrcp_resource_container_t *resource_container, mrcp_message_t *message);

MRCP_END_EXTERN_C

#endif /*__MRCP_PARSER_H__*/
