/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "mrcp_description.h"

void mrcp_descriptor_init(mrcp_descriptor_t *descriptor)
{
	size_t i;
	descriptor->ip = NULL;
	descriptor->media_count = 0;
	for(i=0; i<MRCP_MAX_MEDIA_COUNT; i++) {
		descriptor->media[i] = NULL;
	}
}

mrcp_media_audio_t* mrcp_audio_media_create(apr_pool_t *pool)
{
	mrcp_media_audio_t* media = apr_palloc(pool,sizeof(mrcp_media_audio_t));
	mrcp_media_audio_init(media);
	media->base.type = MRCP_MEDIA_TYPE_AUDIO;
	return media;
}

mrcp_media_control_t* mrcp_control_media_create(apr_pool_t *pool)
{
	mrcp_media_control_t* media = apr_palloc(pool,sizeof(mrcp_media_control_t));
	mrcp_media_control_init(media);
	media->base.type = MRCP_MEDIA_TYPE_CONTROL;
	return media;
}

mrcp_status_t mrcp_descriptor_media_add(mrcp_descriptor_t *descriptor, mrcp_media_base_t *media)
{
	if(descriptor->media_count >= MRCP_MAX_MEDIA_COUNT) {
		return MRCP_STATUS_FAILURE;
	}
	media->id = descriptor->media_count;
	descriptor->media[descriptor->media_count++] = media;
	return MRCP_STATUS_SUCCESS;
}

mrcp_media_control_t* mrcp_control_media_get(mrcp_descriptor_t *descriptor, const char *resource_name)
{
	size_t i=0;
	mrcp_media_control_t *media;
	for(i=0; i<descriptor->media_count; i++) {
		if(descriptor->media[i] && descriptor->media[i]->type == MRCP_MEDIA_TYPE_CONTROL) {
			media = (mrcp_media_control_t *)descriptor->media[i];
			if(apt_str_compare(media->resource_name,resource_name) == TRUE) {
				return media;
			}
		}
	}
	return NULL;
}

mrcp_media_control_t* mrcp_enabled_control_media_get(mrcp_descriptor_t *descriptor)
{
	size_t i=0;
	mrcp_media_control_t *media;
	for(i=0; i<descriptor->media_count; i++) {
		if(descriptor->media[i] && descriptor->media[i]->type == MRCP_MEDIA_TYPE_CONTROL) {
			media = (mrcp_media_control_t *)descriptor->media[i];
			if(media->base.state == MRCP_MEDIA_ENABLED) {
				return media;
			}
		}
	}
	return NULL;
}

mrcp_media_audio_t* mrcp_audio_media_get(mrcp_descriptor_t *descriptor, size_t mid)
{
	size_t i=0;
	mrcp_media_audio_t *media;
	for(i=0; i<descriptor->media_count; i++) {
		if(descriptor->media[i] && descriptor->media[i]->type == MRCP_MEDIA_TYPE_AUDIO) {
			media = (mrcp_media_audio_t *)descriptor->media[i];
			if(media->mid == mid) {
				return media;
			}
		}
	}
	return NULL;
}

mrcp_media_audio_t* mrcp_audio_media_get_by_direction(mrcp_descriptor_t *descriptor, mrcp_audio_direction_t direction)
{
	size_t i=0;
	mrcp_media_audio_t *media;
	for(i=0; i<descriptor->media_count; i++) {
		if(descriptor->media[i] && descriptor->media[i]->type == MRCP_MEDIA_TYPE_AUDIO) {
			media = (mrcp_media_audio_t*)descriptor->media[i];
			if((media->direction & direction) == 0) {
				return media;
			}
		}
	}
	return NULL;
}
