/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MEDIA_TYPES_H__
#define __MEDIA_TYPES_H__

/**
 * @file media_types.h
 * @brief Base Media Types Declaration
 */ 

#include <apr.h>
#include <apr_errno.h>
#include <apr_pools.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Opaque media processor declaration */
typedef struct media_processor_t media_processor_t;

/** Opaque media context declaration */
typedef struct media_context_t media_context_t;

/** Opaque media connector declaration */
typedef struct media_connector_t media_connector_t;

/** Opaque codec manager declaration */
typedef struct codec_manager_t codec_manager_t;

/** Opaque RTP session declaration */
typedef struct rtp_session_t rtp_session_t;

/** Opaque audio source declaration */
typedef struct audio_source_t audio_source_t;

/** Opaque audio sink declaration */
typedef struct audio_sink_t audio_sink_t;

#ifdef __cplusplus
}
#endif

#endif /*__MEDIA_TYPES_H__*/
