/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MEDIA_FRAME_H__
#define __MEDIA_FRAME_H__

/**
 * @file media_frame.h
 * @brief Media Frame Definition
 */ 

#include <apr.h>
#include "codec_descriptor.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Media frame types */
typedef enum {
	MEDIA_FRAME_TYPE_NONE  = 0,
	MEDIA_FRAME_TYPE_AUDIO = 0x1,
	MEDIA_FRAME_TYPE_EVENT = 0x2
} media_frame_type;

typedef struct named_event_frame_t named_event_frame_t;
/** Named event (rfc2833, out-of-band DTMF) */
struct named_event_frame_t {
	apr_uint32_t event_id: 8;
#if (APR_IS_BIGENDIAN == 1)
	apr_uint32_t edge:     1;
	apr_uint32_t reserved: 1;
	apr_uint32_t volume:   6;
#else
	apr_uint32_t volume:   6;
	apr_uint32_t reserved: 1;
	apr_uint32_t edge:     1;
#endif
	apr_uint32_t duration: 16;
};



typedef struct media_frame_t media_frame_t;
/** Media frame */
struct media_frame_t {
	media_frame_type    type;

	codec_frame_t       codec_frame;
	named_event_frame_t event_frame;
};

/** Initialize media frame */
static APR_INLINE void media_frame_init(media_frame_t *media_frame)
{
	media_frame->type = MEDIA_FRAME_TYPE_NONE;
}


#ifdef __cplusplus
}
#endif

#endif /*__MEDIA_FRAME_H__*/
