dnl  MRCP_CHECK_APU

AC_DEFUN([MRCP_CHECK_APU],
[
  AC_MSG_NOTICE([Apache Portable Runtime Utility (APU) library configuration])

  APR_FIND_APU("", "", 1, 1)

  if test $apu_found = "no"; then
    AC_MSG_WARN([APU not found])
    MRCP_DOWNLOAD_APU
  fi

  if test $apu_found = "reconfig"; then
    AC_MSG_WARN([APU reconfig])
  fi

  dnl check APU version number

  apu_version="`$apu_config --version`"
  AC_MSG_RESULT([$apu_version])

  dnl Get libraries and thread flags from APU

  LDFLAGS="$LDFLAGS `$apu_config --ldflags`"

  MRCP_APU_INCLUDES="`$apu_config --includes`"
  MRCP_APU_LIBS="`$apu_config --link-libtool --libs`"

  AC_SUBST(MRCP_APU_INCLUDES)
  AC_SUBST(MRCP_APU_LIBS)
])

dnl MRCP_DOWNLOAD_APU
dnl no apr-util found, print out a message telling the user what to do
AC_DEFUN([MRCP_DOWNLOAD_APU],
[
  echo "The Apache Portable Runtime Utility (APU) library cannot be found."
  echo "Either install APRUTIL on this system and supply the appropriate"
  echo "--with-apr-util option"
  AC_MSG_ERROR([no suitable APU found])
])
