/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include "apt_producer_task.h"

struct apt_producer_task_t {
	apt_task_msg_pool_t   *msg_pool;
	apt_task_t            *task;
};

APT_DECLARE(apt_producer_task_t*) apt_producer_task_create(void *data, apt_task_event_handler main,
                                                   apt_task_msg_pool_t *msg_pool, apr_pool_t *pool)
{
	apt_producer_task_t *producer_task = apr_palloc(pool,sizeof(apt_producer_task_t));
	producer_task->msg_pool = msg_pool;
	producer_task->task = apt_task_create(data,main,pool);
	return producer_task;
}

APT_DECLARE(apt_bool_t) apt_producer_task_destroy(apt_producer_task_t *producer_task)
{
	apt_task_destroy(producer_task->task);
	if(producer_task->msg_pool) {
		apt_task_msg_pool_destroy(producer_task->msg_pool);
	}
	return TRUE;
}


APT_DECLARE(apt_bool_t) apt_producer_task_start(apt_producer_task_t *producer_task)
{
	return apt_task_start(producer_task->task);
}

APT_DECLARE(apt_bool_t) apt_producer_task_terminate(apt_producer_task_t *producer_task, 
                                                       apt_bool_t wait_until_terminate)
{
	return apt_task_terminate(producer_task->task,wait_until_terminate);
}

APT_DECLARE(apt_task_msg_t*) apt_producer_task_msg_get(apt_producer_task_t *producer_task)
{
	apt_task_msg_t *task_msg = apt_task_msg_acquire(producer_task->msg_pool);
	if(task_msg) {
		task_msg->msg_pool = producer_task->msg_pool;
	}
	return task_msg;
}

APT_DECLARE(apt_task_t*) apt_producer_task_get(apt_producer_task_t *producer_task)
{
	return producer_task->task;
}

APT_DECLARE(apt_bool_t) apt_producer_task_is_terminating(apt_producer_task_t *producer_task)
{
	return (apt_task_state_get(producer_task->task) == TASK_STATE_TERMINATE_REQUESTED) ? TRUE : FALSE;
}
