/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __APT_PTR_QUEUE_H__
#define __APT_PTR_QUEUE_H__

/**
 * @file apt_ptr_queue.h
 * @brief FIFO Queue of Opaque void*
 */ 

#include "apt.h"

APT_BEGIN_EXTERN_C

/** Opaque queue declaration */
typedef struct apt_ptr_queue_t apt_ptr_queue_t;

/**
 * Create queue.
 * @param pool the pool to allocate queue from
 * @return the created queue
 */
APT_DECLARE(apt_ptr_queue_t*) apt_ptr_queue_create(apr_pool_t *pool);

/**
 * Destroy queue.
 * @param queue the queue to destroy
 */
APT_DECLARE(void) apt_ptr_queue_destroy(apt_ptr_queue_t *queue);

/**
 * Push data to queue as first in, first out.
 * @param queue the queue to push message to
 * @param data the data to push
 * @param id the unique identifier associated with the message
 */
APT_DECLARE(apt_bool_t) apt_ptr_queue_push(apt_ptr_queue_t *queue, void *data);

/**
 * Pop data from queue as first in, first out
 * @param queue the queue to pop data from
 * @return the popped data (if any)
 */
APT_DECLARE(void*) apt_ptr_queue_pop(apt_ptr_queue_t *queue);

/**
 * Retrieve the head of the queue.
 * @param queue the queue to retrieve from
 */
APT_DECLARE(void*) apt_ptr_queue_head(apt_ptr_queue_t *queue);

/**
 * Retrieve the tail of the queue.
 * @param queue the queue to retrieve from
 */
APT_DECLARE(void*) apt_ptr_queue_tail(apt_ptr_queue_t *queue);


APT_END_EXTERN_C

#endif /*__APT_PTR_QUEUE_H__*/
