/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#include <stdlib.h>
#include "mrcp.h"

static char process_cmdline(char *cmdline)
{
	char* name = cmdline;
	char* arg;
	if((arg = strchr(cmdline, ' ')) != 0) {
		*arg++ = '\0';
	}

	if(strcmp(name,"loglevel") == 0) {
		if(arg) {
			apt_log_priority_set(atoi(arg));
		}
	}
	else if(strcmp(name,"exit") == 0 || strcmp(name,"quit") == 0) {
		return 0;
	}
	else if(strcmp(name,"help") == 0) {
		printf("usage:\n");
		printf("- loglevel [level] (set loglevel, one of 0,1...7)\n");
		printf("- quit, exit\n");
	}
	else {
		printf("unknown command: %s (input help for usage)\n",name);
	}
	return 1;
}
void console_cmdline_run()
{
	size_t i;
	char running = 1;
	char cmdline[1024];

	do {
		printf(">");
		memset(&cmdline, 0, sizeof(cmdline));
		for(i = 0; i < sizeof(cmdline); i++) {
			cmdline[i] = (char) getchar();
			if (cmdline[i] == '\n') {
				cmdline[i] = '\0';
				break;
			}
		}
		if(*cmdline) {
			running = process_cmdline(cmdline);
		}
	}
	while(running != 0);
}
