/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_SERVER_RESOURCE_H__
#define __MRCP_SERVER_RESOURCE_H__

/**
 * @file mrcp_server_resource.h
 * @brief MRCP Server Resource Definition.
 */ 

#include "mrcp_resource.h"
#include "mrcp_server_plugin.h"
#include "mrcp_message.h"

MRCP_BEGIN_EXTERN_C

/** MRCP channel states */
typedef enum {
	MRCP_CHANNEL_STATE_NONE,
	MRCP_CHANNEL_STATE_OPENED,
	MRCP_CHANNEL_STATE_CLOSE_REQUESTED,
	MRCP_CHANNEL_STATE_CLOSED
} mrcp_server_channel_state_t;

/** MRCP server channel */
struct mrcp_server_channel_t {
	/** MRCP channel state */
	mrcp_server_channel_state_t state;
	/** Resource specific data */
	void                       *data;
	/** Plugin specific data (handle) */
	void                       *handle;
	/** MRCP resource entire channel is type of */
	mrcp_server_resource_t     *resource;
	/** MRCP session entire channel belongs to (added for fast reverse search) */
	mrcp_session_t             *session;
	/** MRCP connection */
	mrcp_connection_t          *connection;
	
	/** Audio source entire channel is assigned to */
	audio_source_t             *audio_source;
	/** Audio sink entire channel is assigned to */
	audio_sink_t               *audio_sink;

	/** Properties available for entire channel */
	mrcp_message_header_t       properties;
};


/** Prototype of MRCP method handler */
typedef mrcp_status_t (*mrcp_server_method_handler_t)(mrcp_server_channel_t *channel, mrcp_message_t *request_message, mrcp_message_t *response_message, mrcp_server_method_plugin_t method_plugin);
/** Prototype of MRCP event handler */
typedef mrcp_status_t (*mrcp_server_event_handler_t)(mrcp_server_channel_t *channel, mrcp_message_t *event_message);
/** Prototype of MRCP response handler */
typedef mrcp_status_t (*mrcp_server_response_handler_t)(mrcp_server_channel_t *channel, mrcp_message_t *response_message);

/** MRCP server resource */
struct mrcp_server_resource_t {
	/** Base resource (must be the first memver in struct) */
	mrcp_resource_t base;

	/** Open MRCP channel */
	mrcp_server_channel_state_t (*channel_open)(mrcp_server_channel_t *channel, apr_pool_t *pool);
	/** Close MRCP channel */
	mrcp_server_channel_state_t (*channel_close)(mrcp_server_channel_t *channel);

	/** Registered MRCP methods */
	mrcp_server_method_handler_t  *method_array;
	/** Registered MRCP events */
	mrcp_server_event_handler_t   *event_array;

	/** Registered MRCP response handler */
	mrcp_server_response_handler_t response_handler;

	/** Plugin to entire resourse */
	mrcp_server_plugin_t          *plugin;
};

MRCP_END_EXTERN_C

#endif /*__MRCP_SERVER_RESOURCE_H__*/
