/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_RESOURCE_MANAGER_H__
#define __MRCP_RESOURCE_MANAGER_H__

/**
 * @file mrcp_resource_manager.h
 * @brief MRCP Resource Manager Definition
 */ 

#include "mrcp_server_types.h"
#include "mrcp_client_types.h"
#include "mrcp_message.h"

MRCP_BEGIN_EXTERN_C

/** Create MRCP resource container and initialize MRCP parser resources */
mrcp_resource_container_t* mrcp_parser_resource_container_create(mrcp_version_t version,
																 const apt_string_table_item_t *resource_string_table,
																 apr_pool_t *pool);

/** Create MRCP resource container and initialize MRCP server resources */
mrcp_resource_container_t* mrcp_server_resource_container_create(mrcp_version_t version,
																 const apt_string_table_item_t *resource_string_table,
																 apr_pool_t *pool);

/** Create MRCP resource container and initialize MRCP client resources */
mrcp_resource_container_t* mrcp_client_resource_container_create(mrcp_version_t version,
																 const apt_string_table_item_t *resource_string_table,
																 apr_pool_t *pool);

MRCP_END_EXTERN_C

#endif /*__MRCP_RESOURCE_MANAGER_H__*/
