/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_TYPES_H__
#define __MRCP_TYPES_H__

/**
 * @file mrcp_types.h
 * @brief Basic MRCP Types
 */ 

#include "mrcp.h"
#include "apt_unique_id.h"

MRCP_BEGIN_EXTERN_C

/** Protocol version */
typedef enum {
	/** Unknown version */
	MRCP_VERSION_UNKNOWN = 0, 
	/** MRCPv1 (RFC 4463) */
	MRCP_VERSION_1 = 1, 
	/** MRCPv2 (draft-ietf-speechsc-mrcpv2-12) */
	MRCP_VERSION_2 = 2  
} mrcp_version_t;

/** Method identifier associated with method name. */
typedef size_t mrcp_method_id;

/** Message identifier used in request/response/event messages. */
typedef size_t  mrcp_request_id;

/** Resource identifier associated with resource name. */
typedef size_t mrcp_resource_id;

typedef struct apt_unique_id mrcp_session_id;

/** Mode of the audio channel.*/
typedef enum {
	MRCP_AUDIO_CHANNEL_PASSIVE,
	MRCP_AUDIO_CHANNEL_ACTIVE,
	MRCP_AUDIO_CHANNEL_NONE
} mrcp_audio_channel_mode_t;

/** Opaque MRCP (parser) resource declaration. */
typedef struct mrcp_resource_t mrcp_resource_t;

/** Opaque MRCP resource container declaration. */
typedef struct mrcp_resource_container_t mrcp_resource_container_t;

/** Opaque media agent declaration. */
typedef struct mrcp_media_agent_t mrcp_media_agent_t;

/** Opaque audio channel declaration. */
typedef struct mrcp_audio_channel_t mrcp_audio_channel_t;

/** Opaque signaling channel declaration. */
typedef struct mrcp_signaling_channel_t mrcp_signaling_channel_t;

/** Opaque signaling agent declaration. */
typedef struct mrcp_signaling_agent_t mrcp_signaling_agent_t;

/** Opaque connection declaration. */
typedef struct mrcp_connection_t mrcp_connection_t;

/** Opaque protocol (connection) agent declaration. */
typedef struct mrcp_proto_agent_t  mrcp_proto_agent_t;

/** Opaque session declaration. */
typedef struct mrcp_session_t mrcp_session_t;

MRCP_END_EXTERN_C

#endif /*__MRCP_TYPES_H__*/
