/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_CONNECTION_H__
#define __MRCP_CONNECTION_H__

/**
 * @file mrcp_connection.h
 * @brief MRCP Connection Definition
 */ 

#include "mrcp_message.h"

MRCP_BEGIN_EXTERN_C

typedef struct mrcp_connection_method_set_t mrcp_connection_method_set_t;
typedef struct mrcp_connection_event_set_t mrcp_connection_event_set_t;

/** MRCP connection (v2) */
struct mrcp_connection_t {
	/** Set of connection virtual methods */
	const mrcp_connection_method_set_t *method_set;
	/** Set of connection virtual events */
	const mrcp_connection_event_set_t  *event_set;
	/** Actual data set by inherited object */
	void                               *object;
	
	/** Protocol agent, channel is created by */
	mrcp_proto_agent_t                 *agent;
};

/** Set of connection virtual methods */
struct mrcp_connection_method_set_t {
	/** Disconnect existing connection if connection no more referenced */
	mrcp_status_t (*disconnect)(mrcp_connection_t *connection);

	/** Send MRCP message to peer (server/client) */
	mrcp_status_t (*send)(mrcp_connection_t *connection, mrcp_message_t *mrcp_message);
};

/** Set of connection event handlers */
struct mrcp_connection_event_set_t {
	mrcp_status_t (*on_disconnect)(mrcp_connection_t *connection);
	/** Receive MRCP message from peer (server/client) */
	mrcp_status_t (*on_receive)(mrcp_connection_t *connection, mrcp_message_t *mrcp_message);
};


MRCP_END_EXTERN_C

#endif /*__MRCP_CONNECTION_H__*/
