/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_AUDIO_CHANNEL_H__
#define __MRCP_AUDIO_CHANNEL_H__

/**
 * @file mrcp_audio_channel.h
 * @brief MRCP Audio Channel Definition
 */ 

#include "mrcp_types.h"
#include "mrcp_media_audio.h"
#include "media_types.h"

MRCP_BEGIN_EXTERN_C

typedef struct mrcp_audio_channel_method_set_t mrcp_audio_channel_method_set_t;

/** Audio channel base */
struct mrcp_audio_channel_t {
	/** Set of audio channel virtual methods */
	const mrcp_audio_channel_method_set_t *method_set;
	/** Actual data set by inherited object */
	void                                  *object;

	/** Signaling agent, channel is created by */
	mrcp_media_agent_t                    *agent;
	/** Session, channel belongs to */
	mrcp_session_t                        *session;

	mrcp_audio_channel_mode_t             mode;

	/** Local MRCP media */
	mrcp_media_audio_t                    *local_media;
	/** Remote MRCP media */
	mrcp_media_audio_t                    *remote_media;

	/** Audio source interface */
	audio_source_t                        *audio_source;
	/** Audio sink interface */
	audio_sink_t                          *audio_sink;
};

/** Audio request type */
typedef enum {
	MRCP_AUDIO_REQUEST_RECEIVE_ANSWER,
	MRCP_AUDIO_REQUEST_RECEIVE_OFFER,
} mrcp_audio_request_t;

/** Set of audio channel virtual methods */
struct mrcp_audio_channel_method_set_t {
	mrcp_status_t (*destroy)(mrcp_audio_channel_t *channel);

	mrcp_status_t (*modify)(mrcp_audio_channel_t *channel, mrcp_audio_request_t request);

	mrcp_status_t (*source_connect)(mrcp_audio_channel_t *channel, audio_source_t *source);
	mrcp_status_t (*source_disconnect)(mrcp_audio_channel_t *channel, audio_source_t *source);
	mrcp_status_t (*sink_connect)(mrcp_audio_channel_t *channel, audio_sink_t *sink);
	mrcp_status_t (*sink_disconnect)(mrcp_audio_channel_t *channel, audio_sink_t *sink);
};


MRCP_END_EXTERN_C

#endif /*__MRCP_AUDIO_CHANNEL_H__*/
