/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __MRCP_CLIENT_RESOURCE_H__
#define __MRCP_CLIENT_RESOURCE_H__

/**
 * @file mrcp_client_resource.h
 * @brief MRCP Client Resource Definition.
 */ 

#include "mrcp_client_types.h"
#include "media_types.h"

MRCP_BEGIN_EXTERN_C

/** MRCP client channel states */
typedef enum {
	CHANNEL_STATE_NONE,
	CHANNEL_STATE_PENDING_CREATE,
	CHANNEL_STATE_PENDING_DESTROY
} mrcp_client_channel_state;

/** MRCP client channel */
struct mrcp_client_channel_t {
	mrcp_client_channel_state state;
	mrcp_resource_t          *resource;

	mrcp_audio_channel_t     *audio_channel;

	audio_source_t           *audio_source;
	audio_sink_t             *audio_sink;
};


MRCP_END_EXTERN_C

#endif /*__MRCP_CLIENT_RESOURCE_H__*/
