/*
 * OpenMRCP - Open Source Media Resource Control Protocol Stack
 * Copyright (C) 2007, Cepstral LLC
 *
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Author(s):
 * Arsen Chaloyan <achaloyan@yahoo.com>
 *
 * Contributor(s):
 *
 */

#ifndef __RTP_H__
#define __RTP_H__

/**
 * @file rtp.h
 * @brief RTP Definitions
 */ 

#include <apr.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Protocol version. */
#define RTP_VERSION 2

typedef struct rtp_header_t rtp_header_t;
/** RTP header. */
struct rtp_header_t {
#if (APR_IS_BIGENDIAN == 1)
	/** protocol version */
	apr_uint32_t version:   2;
	/** padding flag */
	apr_uint32_t padding:   1;
	/** header extension flag */
	apr_uint32_t extension: 1;
	/** CSRC count */
	apr_uint32_t count:     4;
	/** marker bit */
	apr_uint32_t marker:    1;
	/** payload type */
	apr_uint32_t type:      7;
#else
	/** CSRC count */
	apr_uint32_t count:     4;
	/** header extension flag */
	apr_uint32_t extension: 1;
	/** padding flag */
	apr_uint32_t padding:   1;
	/** protocol version */
	apr_uint32_t version:   2;
	/** payload type */
	apr_uint32_t type:      7;
	/** marker bit */
	apr_uint32_t marker:    1;
#endif	
	
	/** sequence number */
	apr_uint32_t sequence:  16;
	/** timestamp */
	apr_uint32_t timestamp;
	/** synchronization source */
	apr_uint32_t ssrc;
};

typedef struct rtp_extension_header_t rtp_extension_header_t;
/** RTP extension header. */
struct rtp_extension_header_t
{
	/** profile */
	apr_uint16_t profile;
	/** length */
	apr_uint16_t length;
};


#ifdef __cplusplus
}
#endif

#endif /*__RTP_H__*/
